/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.EndDirective;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdCompressCtx
extends AutoCloseBase {
    private long nativePtr = 0L;
    private ZstdDictCompress compression_dict = null;

    private native void init();

    private native void free();

    public ZstdCompressCtx() {
        this.init();
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    public ZstdCompressCtx setLevel(int level) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setLevel0(level);
        this.releaseSharedLock();
        return this;
    }

    private native void setLevel0(int var1);

    public ZstdCompressCtx setChecksum(boolean checksumFlag) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setChecksum0(checksumFlag);
        this.releaseSharedLock();
        return this;
    }

    private native void setChecksum0(boolean var1);

    public ZstdCompressCtx setWorkers(int workers) {
        this.acquireSharedLock();
        Zstd.setCompressionWorkers(this.nativePtr, workers);
        this.releaseSharedLock();
        return this;
    }

    public ZstdCompressCtx setContentSize(boolean contentSizeFlag) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setContentSize0(contentSizeFlag);
        this.releaseSharedLock();
        return this;
    }

    private native void setContentSize0(boolean var1);

    public ZstdCompressCtx setDictID(boolean dictIDFlag) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setDictID0(dictIDFlag);
        this.releaseSharedLock();
        return this;
    }

    private native void setDictID0(boolean var1);

    public ZstdCompressCtx setLong(int windowLog) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        Zstd.setCompressionLong(this.nativePtr, windowLog);
        this.releaseSharedLock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdCompressCtx loadDict(ZstdDictCompress dict) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        dict.acquireSharedLock();
        try {
            long result = this.loadCDictFast0(dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.compression_dict = dict;
        }
        finally {
            dict.releaseSharedLock();
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadCDictFast0(ZstdDictCompress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdCompressCtx loadDict(byte[] dict) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long result = this.loadCDict0(dict);
            if (Zstd.isError(result)) {
                throw new ZstdException(result);
            }
            this.compression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadCDict0(byte[] var1);

    private void ensureOpen() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
    }

    public void reset() {
        this.ensureOpen();
        long result = this.reset0();
        if (Zstd.isError(result)) {
            throw new ZstdException(result);
        }
    }

    private native long reset0();

    public void setPledgedSrcSize(long srcSize) {
        this.ensureOpen();
        long result = this.setPledgedSrcSize0(srcSize);
        if (Zstd.isError(result)) {
            throw new ZstdException(result);
        }
    }

    private native long setPledgedSrcSize0(long var1);

    public boolean compressDirectByteBufferStream(ByteBuffer dst, ByteBuffer src, EndDirective endOp) {
        this.ensureOpen();
        long result = this.compressDirectByteBufferStream0(dst, dst.position(), dst.limit(), src, src.position(), src.limit(), endOp.value());
        if ((result & 0x80000000L) != 0L) {
            long code = result & 0xFFL;
            throw new ZstdException(code, Zstd.getErrorName(code));
        }
        src.position((int)(result & Integer.MAX_VALUE));
        dst.position((int)(result >>> 32) & Integer.MAX_VALUE);
        return result >>> 63 == 1L;
    }

    private native long compressDirectByteBufferStream0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressDirectByteBuffer(ByteBuffer dstBuff, int dstOffset, int dstSize, ByteBuffer srcBuff, int srcOffset, int srcSize) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        if (!srcBuff.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!dstBuff.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long size = this.compressDirectByteBuffer0(dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long compressDirectByteBuffer0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressByteArray(byte[] dstBuff, int dstOffset, int dstSize, byte[] srcBuff, int srcOffset, int srcSize) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long size = this.compressByteArray0(dstBuff, dstOffset, dstSize, srcBuff, srcOffset, srcSize);
            if (Zstd.isError(size)) {
                throw new ZstdException(size);
            }
            if (size > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)size;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long compressByteArray0(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public int compress(ByteBuffer dstBuf, ByteBuffer srcBuf) {
        int size = this.compressDirectByteBuffer(dstBuf, dstBuf.position(), dstBuf.limit() - dstBuf.position(), srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        dstBuf.position(dstBuf.position() + size);
        return size;
    }

    public ByteBuffer compress(ByteBuffer srcBuf) throws ZstdException {
        long maxDstSize = Zstd.compressBound(srcBuf.limit() - srcBuf.position());
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        ByteBuffer dstBuf = ByteBuffer.allocateDirect((int)maxDstSize);
        int size = this.compressDirectByteBuffer(dstBuf, 0, (int)maxDstSize, srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
        srcBuf.position(srcBuf.limit());
        dstBuf.limit(size);
        return dstBuf;
    }

    public int compress(byte[] dst, byte[] src) {
        return this.compressByteArray(dst, 0, dst.length, src, 0, src.length);
    }

    public byte[] compress(byte[] src) {
        long maxDstSize = Zstd.compressBound(src.length);
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        byte[] dst = new byte[(int)maxDstSize];
        int size = this.compressByteArray(dst, 0, dst.length, src, 0, src.length);
        return Arrays.copyOfRange(dst, 0, size);
    }

    static {
        Native.load();
    }
}

