/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.checkreturnvalue.AutoValueRules;
import com.google.errorprone.bugpatterns.checkreturnvalue.ErrorMessages;
import com.google.errorprone.bugpatterns.checkreturnvalue.ExternalCanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.checkreturnvalue.PackagesRule;
import com.google.errorprone.bugpatterns.checkreturnvalue.ProtoRules;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicyEvaluator;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.bugpatterns.checkreturnvalue.Rules;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(altNames={"ResultOfMethodCallIgnored", "ReturnValueIgnored"}, summary="The result of this call must be used", documentSuppression=false, severity=BugPattern.SeverityLevel.ERROR)
public class CheckReturnValue
extends AbstractReturnValueIgnored
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final String CHECK_RETURN_VALUE = "CheckReturnValue";
    private static final String CAN_IGNORE_RETURN_VALUE = "CanIgnoreReturnValue";
    private static final ImmutableList<String> MUTUALLY_EXCLUSIVE_ANNOTATIONS = ImmutableList.of((Object)"CheckReturnValue", (Object)"CanIgnoreReturnValue");
    public static final String CHECK_ALL_CONSTRUCTORS = "CheckReturnValue:CheckAllConstructors";
    public static final String CHECK_ALL_METHODS = "CheckReturnValue:CheckAllMethods";
    static final String CRV_PACKAGES = "CheckReturnValue:Packages";
    private static final ResultUsePolicyEvaluator.MethodInfo<VisitorState, Symbol, Symbol.MethodSymbol> METHOD_INFO = new ResultUsePolicyEvaluator.MethodInfo<VisitorState, Symbol, Symbol.MethodSymbol>(){

        @Override
        public Stream<Symbol> scopeMembers(ResultUseRule.RuleScope scope, Symbol.MethodSymbol method, VisitorState context) {
            switch (scope) {
                case ENCLOSING_ELEMENTS: {
                    return ASTHelpers.enclosingElements((Symbol)method).filter(s -> s instanceof Symbol.ClassSymbol || s instanceof Symbol.PackageSymbol);
                }
                case GLOBAL: 
                case METHOD: {
                    return Stream.of(method);
                }
            }
            throw new AssertionError((Object)scope);
        }

        @Override
        public ResultUsePolicyEvaluator.MethodInfo.MethodKind getMethodKind(Symbol.MethodSymbol method) {
            switch (method.getKind()) {
                case METHOD: {
                    return ResultUsePolicyEvaluator.MethodInfo.MethodKind.METHOD;
                }
                case CONSTRUCTOR: {
                    return ResultUsePolicyEvaluator.MethodInfo.MethodKind.CONSTRUCTOR;
                }
            }
            return ResultUsePolicyEvaluator.MethodInfo.MethodKind.OTHER;
        }
    };
    private final MessageTrailerStyle messageTrailerStyle;
    private final ResultUsePolicyEvaluator<VisitorState, Symbol, Symbol.MethodSymbol> evaluator;

    @Inject
    CheckReturnValue(ErrorProneFlags flags, ConstantExpressions constantExpressions) {
        super(constantExpressions);
        this.messageTrailerStyle = flags.getEnum("CheckReturnValue:MessageTrailerStyle", MessageTrailerStyle.class).orElse(MessageTrailerStyle.NONE);
        ResultUsePolicyEvaluator.Builder<VisitorState, Symbol, Symbol.MethodSymbol> builder = ResultUsePolicyEvaluator.builder(METHOD_INFO).addRules(Rules.mapAnnotationSimpleName(CHECK_RETURN_VALUE, ResultUsePolicy.EXPECTED), Rules.mapAnnotationSimpleName(CAN_IGNORE_RETURN_VALUE, ResultUsePolicy.OPTIONAL), ProtoRules.protoBuilders(), ProtoRules.mutableProtos(), AutoValueRules.autoValues(), AutoValueRules.autoValueBuilders(), AutoValueRules.autoBuilders(), ExternalCanIgnoreReturnValue.externalIgnoreList());
        ImmutableList crvPackages = flags.getListOrEmpty(CRV_PACKAGES);
        if (!crvPackages.isEmpty()) {
            builder.addRule(PackagesRule.fromPatterns((Iterable<String>)crvPackages));
        }
        this.evaluator = builder.addRule(Rules.globalDefault(CheckReturnValue.defaultPolicy(flags, CHECK_ALL_METHODS), CheckReturnValue.defaultPolicy(flags, CHECK_ALL_CONSTRUCTORS))).build();
    }

    private static Optional<ResultUsePolicy> defaultPolicy(ErrorProneFlags flags, String flag) {
        return flags.getBoolean(flag).map(check -> check != false ? ResultUsePolicy.EXPECTED : ResultUsePolicy.OPTIONAL);
    }

    public Matcher<ExpressionTree> specializedMatcher() {
        return (Matcher & Serializable)(tree, state) -> this.getMethodPolicy((ExpressionTree)tree, state).equals((Object)ResultUsePolicy.EXPECTED);
    }

    private static Optional<Symbol.MethodSymbol> methodToInspect(ExpressionTree tree) {
        ClassTree anonymousClazz;
        if (tree instanceof NewClassTree && (anonymousClazz = ((NewClassTree)tree).getClassBody()) != null) {
            Optional<MethodTree> constructor = anonymousClazz.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(mt -> ASTHelpers.getSymbol((MethodTree)mt).isConstructor()).findFirst();
            return constructor.map(MethodTree::getBody).map(block -> block.getStatements().get(0)).map(ExpressionStatementTree.class::cast).map(ExpressionStatementTree::getExpression).map(MethodInvocationTree.class::cast).map(ASTHelpers::getSymbol);
        }
        return CheckReturnValue.methodSymbol(tree);
    }

    private static Optional<Symbol.MethodSymbol> methodSymbol(ExpressionTree tree) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        return sym instanceof Symbol.MethodSymbol ? Optional.of((Symbol.MethodSymbol)sym) : Optional.empty();
    }

    @Override
    public ResultUsePolicy getMethodPolicy(ExpressionTree expression, VisitorState state) {
        return CheckReturnValue.methodToInspect(expression).map(method -> this.evaluator.evaluate((Symbol.MethodSymbol)method, state)).orElse(ResultUsePolicy.UNSPECIFIED);
    }

    @Override
    public boolean isCovered(ExpressionTree tree, VisitorState state) {
        return CheckReturnValue.methodToInspect(tree).stream().flatMap(method -> this.evaluator.evaluations((Symbol.MethodSymbol)method, state)).findFirst().isPresent();
    }

    @Override
    public ImmutableMap<String, ?> getMatchMetadata(ExpressionTree tree, VisitorState state) {
        return CheckReturnValue.methodToInspect(tree).stream().flatMap(method -> this.evaluator.evaluations((Symbol.MethodSymbol)method, state)).findFirst().map(evaluation -> ImmutableMap.of((Object)"rule", evaluation.rule(), (Object)"policy", (Object)((Object)evaluation.policy()), (Object)"scope", (Object)((Object)evaluation.scope()))).orElse(ImmutableMap.of());
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)tree);
        ImmutableList<String> presentAnnotations = CheckReturnValue.presentCrvRelevantAnnotations(method);
        switch (presentAnnotations.size()) {
            case 0: {
                return Description.NO_MATCH;
            }
            case 1: {
                break;
            }
            default: {
                return this.buildDescription(tree).setMessage(ErrorMessages.conflictingAnnotations(presentAnnotations, "method")).build();
            }
        }
        if (method.getKind() != ElementKind.METHOD) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isVoidType((Type)method.getReturnType(), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String message = ErrorMessages.annotationOnVoid((String)presentAnnotations.get(0), "methods");
        return this.buildDescription(tree).setMessage(message).build();
    }

    private static ImmutableList<String> presentCrvRelevantAnnotations(Symbol symbol) {
        return (ImmutableList)MUTUALLY_EXCLUSIVE_ANNOTATIONS.stream().filter(a -> ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)symbol, (String)a)).collect(ImmutableList.toImmutableList());
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableList<String> presentAnnotations = CheckReturnValue.presentCrvRelevantAnnotations(ASTHelpers.getSymbol((ClassTree)tree));
        if (presentAnnotations.size() > 1) {
            return this.buildDescription(tree).setMessage(ErrorMessages.conflictingAnnotations(presentAnnotations, "class")).build();
        }
        return Description.NO_MATCH;
    }

    private Description describeInvocationResultIgnored(ExpressionTree invocationTree, String shortCall, Symbol.MethodSymbol symbol, VisitorState state) {
        String assignmentToUnused = "var unused = ...";
        String message = ErrorMessages.invocationResultIgnored(shortCall, assignmentToUnused, this.apiTrailer(symbol, state));
        return this.buildDescription(invocationTree).addFix(CheckReturnValue.fixAtDeclarationSite(symbol, state)).addAllFixes(this.fixesAtCallSite(invocationTree, state)).setMessage(message).build();
    }

    @Override
    protected Description describeReturnValueIgnored(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        String shortCall = symbol.name + (tree.getArguments().isEmpty() ? "()" : "(...)");
        return this.describeInvocationResultIgnored(tree, shortCall, symbol, state);
    }

    @Override
    protected Description describeReturnValueIgnored(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((NewClassTree)tree);
        String shortCall = "new " + state.getSourceForNode((Tree)tree.getIdentifier()) + (tree.getArguments().isEmpty() ? "()" : "(...)");
        return this.describeInvocationResultIgnored(tree, shortCall, symbol, state);
    }

    @Override
    protected Description describeReturnValueIgnored(MemberReferenceTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
        Type type = state.getTypes().memberType(ASTHelpers.getType((Tree)tree.getQualifierExpression()), symbol);
        String parensAndMaybeEllipsis = type.getParameterTypes().isEmpty() ? "()" : "(...)";
        String shortCall = (CharSequence)(tree.getMode() == MemberReferenceTree.ReferenceMode.NEW ? "new " + state.getSourceForNode((Tree)tree.getQualifierExpression()) : tree.getName()) + parensAndMaybeEllipsis;
        String implementedMethod = (Name)ASTHelpers.getType((Tree)tree).asElement().getSimpleName() + "." + state.getTypes().findDescriptorSymbol(ASTHelpers.getType((Tree)tree).asElement()).getSimpleName();
        String methodReference = state.getSourceForNode((Tree)tree);
        String assignmentLambda = parensAndMaybeEllipsis + " -> { var unused = ...; }";
        String message = ErrorMessages.methodReferenceIgnoresResult(shortCall, methodReference, implementedMethod, assignmentLambda, this.apiTrailer(symbol, state));
        return this.buildDescription(tree).setMessage(message).addFix(CheckReturnValue.fixAtDeclarationSite(symbol, state)).build();
    }

    private String apiTrailer(Symbol.MethodSymbol symbol, VisitorState state) {
        if (ASTHelpers.isLocal((Symbol)ASTHelpers.enclosingClass((Symbol)symbol))) {
            return "";
        }
        switch (this.messageTrailerStyle) {
            case NONE: {
                return "";
            }
            case API_ERASED_SIGNATURE: {
                return "\n\nFull API: " + ExternalCanIgnoreReturnValue.surroundingClass(symbol) + "#" + ExternalCanIgnoreReturnValue.methodNameAndParams(symbol, state.getTypes());
            }
        }
        throw new AssertionError();
    }

    private static Fix fixAtDeclarationSite(Symbol.MethodSymbol symbol, VisitorState state) {
        MethodTree method = CheckReturnValue.findDeclaration(symbol, state);
        if (method == null || ASTHelpers.isGeneratedConstructor((MethodTree)method)) {
            return SuggestedFix.emptyFix();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.prefixWith((Tree)method, "@" + SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)CanIgnoreReturnValue.class.getName()) + " ");
        ASTHelpers.getAnnotationsWithSimpleName(method.getModifiers().getAnnotations(), (String)CHECK_RETURN_VALUE).forEach(arg_0 -> ((SuggestedFix.Builder)fix).delete(arg_0));
        fix.setShortDescription("Annotate the method with @CanIgnoreReturnValue");
        return fix.build();
    }

    private static @Nullable MethodTree findDeclaration(Symbol symbol, VisitorState state) {
        JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(state.context);
        TreePath declPath = Trees.instance(javacEnv).getPath(symbol);
        if (declPath != null && declPath.getCompilationUnit() == state.getPath().getCompilationUnit() && declPath.getLeaf().getKind() == Tree.Kind.METHOD) {
            return (MethodTree)declPath.getLeaf();
        }
        return null;
    }

    static enum MessageTrailerStyle {
        NONE,
        API_ERASED_SIGNATURE;

    }
}

