/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Starting in JDK 13, this call is ambiguous with FileSystem.newFileSystem(Path,Map)", severity=BugPattern.SeverityLevel.WARNING)
public class NewFileSystem
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.nio.file.FileSystems").named("newFileSystem").withParameters("java.nio.file.Path", new String[]{"java.lang.ClassLoader"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree = tree.getArguments().get(1);
        if (!expressionTree.getKind().equals((Object)Tree.Kind.NULL_LITERAL)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.prefixWith((Tree)expressionTree, (String)"(ClassLoader) "));
    }
}

