/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="`return;` is unnecessary at the end of void methods and constructors.", severity=BugPattern.SeverityLevel.WARNING)
public final class ReturnAtTheEndOfVoidFunction
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Type returnType = ASTHelpers.getType((Tree)methodTree.getReturnType());
        if (returnType != null && returnType.getKind() != TypeKind.VOID) {
            return Description.NO_MATCH;
        }
        BlockTree body = methodTree.getBody();
        if (body == null) {
            return Description.NO_MATCH;
        }
        List<? extends StatementTree> statements = body.getStatements();
        if (statements == null || statements.isEmpty()) {
            return Description.NO_MATCH;
        }
        StatementTree lastStatement = (StatementTree)Iterables.getLast(statements);
        if (lastStatement.getKind() != Tree.Kind.RETURN) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodTree, (Fix)SuggestedFix.delete((Tree)lastStatement));
    }
}

