/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

@BugPattern(altNames={"ResultOfMethodCallIgnored", "CheckReturnValue"}, summary="Return value of this method must be used", severity=BugPattern.SeverityLevel.ERROR)
public class ReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final ImmutableSet<String> TYPES_TO_CHECK = ImmutableSet.of((Object)"java.math.BigInteger", (Object)"java.math.BigDecimal", (Object)"java.nio.file.Path");
    private static final Matcher<ExpressionTree> RETURNS_SAME_TYPE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.NEW_CLASS)), (Matcher & Serializable)(tree, state) -> {
        Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree);
        return TYPES_TO_CHECK.contains((Object)receiverType.toString()) && ASTHelpers.isSameType((Type)receiverType, (Type)ASTHelpers.getReturnType((ExpressionTree)tree), (VisitorState)state);
    }});
    private static final Matcher<ExpressionTree> ALLOWED_JAVA_TIME_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().anyClass().named("parse"), MethodMatchers.instanceMethod().anyClass().named("parse"), MethodMatchers.staticMethod().anyClass().named("of"), MethodMatchers.staticMethod().anyClass().named("from"), MethodMatchers.staticMethod().onClassAny(new String[]{"java.time.ZoneId", "org.threeten.bp.ZoneId"}).named("ofOffset"), MethodMatchers.instanceMethod().onExactClassAny(new String[]{"java.time.format.DateTimeFormatterBuilder", "org.threeten.bp.format.DateTimeFormatterBuilder"}).withNameMatching(Pattern.compile("^(append|parse|pad|optional).*")), MethodMatchers.instanceMethod().onExactClassAny(new String[]{"java.time.temporal.ChronoField", "org.threeten.bp.temporal.ChronoField"}).named("checkValidIntValue"), MethodMatchers.instanceMethod().onExactClassAny(new String[]{"java.time.temporal.ChronoField", "org.threeten.bp.temporal.ChronoField"}).named("checkValidValue"), MethodMatchers.instanceMethod().onExactClassAny(new String[]{"java.time.temporal.ValueRange", "org.threeten.bp.temporal.ValueRange"}).named("checkValidValue")});
    private static final Matcher<ExpressionTree> STREAM_METHODS = MethodMatchers.instanceMethod().onDescendantOf("java.util.stream.BaseStream");
    private static final Matcher<ExpressionTree> ARRAYS_METHODS = MethodMatchers.staticMethod().onClass("java.util.Arrays");
    private static final Matcher<ExpressionTree> STRING_METHODS = Matchers.anyMethod().onClass("java.lang.String");
    private static final ImmutableSet<String> PRIMITIVE_TYPES = ImmutableSet.of((Object)"java.lang.Boolean", (Object)"java.lang.Byte", (Object)"java.lang.Character", (Object)"java.lang.Double", (Object)"java.lang.Float", (Object)"java.lang.Integer", (Object[])new String[]{"java.lang.Long", "java.lang.Short"});
    private static final Matcher<ExpressionTree> PRIMITIVE_NON_PARSING_METHODS = Matchers.anyMethod().onClass(TypePredicates.isExactTypeAny(PRIMITIVE_TYPES));
    private static final Matcher<ExpressionTree> PRIMITIVE_PARSING_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.lang.Character").namedAnyOf(new String[]{"toChars", "codePointCount"}), MethodMatchers.staticMethod().onClassAny(PRIMITIVE_TYPES).named("decode"), MethodMatchers.staticMethod().onClassAny(PRIMITIVE_TYPES).withNameMatching(Pattern.compile("^parse[A-z]*")), MethodMatchers.staticMethod().onClassAny(PRIMITIVE_TYPES).named("valueOf").withParameters("java.lang.String", new String[0]), MethodMatchers.staticMethod().onClassAny(PRIMITIVE_TYPES).named("valueOf").withParameters("java.lang.String", new String[]{"int"})});
    private static final Matcher<ExpressionTree> COLLECTION_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("contains").withParameters("java.lang.Object", new String[0]), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("containsAll").withParameters("java.util.Collection", new String[0]), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("isEmpty").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("size").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("stream").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("toArray").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("toArray").withParameters("java.util.function.IntFunction", new String[0])});
    private static final Matcher<ExpressionTree> MAP_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").namedAnyOf(new String[]{"containsKey", "containsValue"}).withParameters("java.lang.Object", new String[0]), MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").namedAnyOf(new String[]{"isEmpty", "size", "entrySet", "keySet", "values"}), MethodMatchers.staticMethod().onClass("java.util.Map").namedAnyOf(new String[]{"of", "copyOf", "entry", "ofEntries"})});
    private static final Matcher<ExpressionTree> MAP_ENTRY_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.util.Map.Entry"), MethodMatchers.instanceMethod().onDescendantOf("java.util.Map.Entry").namedAnyOf(new String[]{"getKey", "getValue"})});
    private static final Matcher<ExpressionTree> ITERABLE_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.lang.Iterable").named("iterator").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.lang.Iterable").named("spliterator").withNoParameters()});
    private static final Matcher<ExpressionTree> ITERATOR_METHODS = MethodMatchers.instanceMethod().onDescendantOf("java.util.Iterator").named("hasNext").withNoParameters();
    private static final Matcher<ExpressionTree> COLLECTOR_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.anyMethod().onClass("java.util.stream.Collector"), Matchers.anyMethod().onClass("java.util.stream.Collectors")});
    private static final Matcher<ExpressionTree> PRIMITIVE_METHODS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(PRIMITIVE_PARSING_METHODS), PRIMITIVE_NON_PARSING_METHODS});
    private static final Matcher<ExpressionTree> OPTIONAL_METHODS = Matchers.anyMethod().onClass("java.util.Optional");
    private static final Matcher<ExpressionTree> TIME_UNIT_METHODS = Matchers.anyMethod().onClass("java.util.concurrent.TimeUnit");
    private static final Matcher<ExpressionTree> JODA_TIME_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.ReadableInstant").named("getMillis").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.ReadableDuration").named("getMillis").withNoParameters()});
    private static final String PROTO_MESSAGE = "com.google.protobuf.MessageLite";
    private static final Matcher<ExpressionTree> PROTO_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onDescendantOf("com.google.protobuf.MessageLite").named("newBuilder"), MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite.Builder").namedAnyOf(new String[]{"build", "buildPartial"})});
    private static final Matcher<ExpressionTree> CLASS_METHODS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyMethod().onClass("java.lang.Class"), Matchers.not((Matcher)MethodMatchers.staticMethod().onClass("java.lang.Class").named("forName")), Matchers.not((Matcher)MethodMatchers.instanceMethod().onExactClass("java.lang.Class").named("getMethod"))});
    private static final Matcher<ExpressionTree> OBJECT_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").namedAnyOf(new String[]{"getClass", "hashCode", "clone", "toString"}).withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").namedAnyOf(new String[]{"equals"}).withParameters("java.lang.Object", new String[0])});
    private static final Matcher<ExpressionTree> CHAR_SEQUENCE_METHODS = Matchers.anyMethod().onClass("java.lang.CharSequence");
    private static final Matcher<ExpressionTree> ENUM_METHODS = Matchers.anyMethod().onClass("java.lang.Enum");
    private static final Matcher<ExpressionTree> THROWABLE_METHODS = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Throwable").namedAnyOf(new String[]{"getCause", "getLocalizedMessage", "getMessage", "getStackTrace", "getSuppressed"});
    private static final Matcher<ExpressionTree> OBJECTS_METHODS = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.util.Objects"), Matchers.not((Matcher)MethodMatchers.staticMethod().onClass("java.util.Objects").namedAnyOf(new String[]{"checkFromIndexSize", "checkFromToIndex", "checkIndex", "requireNonNull", "requireNonNullElse", "requireNonNullElseGet"}))});
    private static final Matcher<ExpressionTree> MODULE_CONSTRUCTORS = Matchers.constructor().forClass(TypePredicates.isDescendantOf((String)"com.google.inject.Module"));
    private static final Matcher<? super ExpressionTree> SPECIALIZED_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{ARRAYS_METHODS, CHAR_SEQUENCE_METHODS, COLLECTION_METHODS, COLLECTOR_METHODS, ENUM_METHODS, ITERABLE_METHODS, ITERATOR_METHODS, JODA_TIME_METHODS, MAP_ENTRY_METHODS, MAP_METHODS, MODULE_CONSTRUCTORS, OBJECTS_METHODS, OBJECT_METHODS, OPTIONAL_METHODS, PRIMITIVE_METHODS, PROTO_METHODS, RETURNS_SAME_TYPE, ReturnValueIgnored::functionalMethod, ReturnValueIgnored::javaTimeTypes, STREAM_METHODS, STRING_METHODS, THROWABLE_METHODS, TIME_UNIT_METHODS});
    private static final ImmutableBiMap<String, Matcher<ExpressionTree>> FLAG_MATCHERS = ImmutableBiMap.of((Object)"ReturnValueIgnored:ClassMethods", CLASS_METHODS);
    private final Matcher<ExpressionTree> matcher;

    private static boolean javaTimeTypes(ExpressionTree tree, VisitorState state) {
        if (Matchers.packageStartsWith((String)"java.time").matches((Tree)tree, state) || Matchers.packageStartsWith((String)"org.threeten.bp").matches((Tree)tree, state)) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol instanceof Symbol.MethodSymbol) {
            String qualifiedName = ASTHelpers.enclosingPackage((Symbol)symbol.owner).getQualifiedName().toString();
            return (qualifiedName.startsWith("java.time") || qualifiedName.startsWith("org.threeten.bp")) && symbol.getModifiers().contains((Object)Modifier.PUBLIC) && !ALLOWED_JAVA_TIME_METHODS.matches((Tree)tree, state);
        }
        return false;
    }

    private static boolean functionalMethod(ExpressionTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.MethodSymbol && ASTHelpers.enclosingPackage((Symbol)symbol.owner).getQualifiedName().contentEquals("java.util.function");
    }

    @Inject
    ReturnValueIgnored(ErrorProneFlags flags, ConstantExpressions constantExpressions) {
        super(constantExpressions);
        this.matcher = ReturnValueIgnored.createMatcher(flags);
    }

    private static Matcher<ExpressionTree> createMatcher(ErrorProneFlags flags) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add(SPECIALIZED_MATCHER);
        FLAG_MATCHERS.keySet().stream().filter(flagName -> flags.getBoolean(flagName).orElse(true)).map(arg_0 -> FLAG_MATCHERS.get(arg_0)).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return Matchers.anyOf((Iterable)builder.build());
    }

    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return this.matcher;
    }

    @Override
    public ImmutableMap<String, ?> getMatchMetadata(ExpressionTree tree, VisitorState state) {
        return FLAG_MATCHERS.values().stream().filter(matcher -> matcher.matches((Tree)tree, state)).findFirst().map(arg_0 -> ((ImmutableBiMap)FLAG_MATCHERS.inverse()).get(arg_0)).map(flag -> ImmutableMap.of((Object)"flag", (Object)flag)).orElse(ImmutableMap.of());
    }

    @Override
    protected String getMessage(Name name) {
        return String.format("Return value of '%s' must be used", name);
    }
}

