/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.SuppressionInfo;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.refaster.RefasterRule;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.Set;

final class RefasterSuppressionHelper {
    static boolean suppressed(RefasterRule<?, ?> rule, Tree tree, Context context) {
        VisitorState state = VisitorState.createForUtilityPurposes((Context)context);
        Symbol sym = ASTHelpers.getDeclaredSymbol((Tree)tree);
        if (sym == null) {
            return false;
        }
        return SuppressionInfo.EMPTY.withExtendedSuppressions(sym, state, (Set)ImmutableSet.of()).suppressedState((Suppressible)new RefasterSuppressible(rule), false, state).equals((Object)SuppressionInfo.SuppressedState.SUPPRESSED);
    }

    private RefasterSuppressionHelper() {
    }

    private static class RefasterSuppressible
    implements Suppressible {
        private final RefasterRule<?, ?> rule;

        RefasterSuppressible(RefasterRule<?, ?> rule) {
            this.rule = rule;
        }

        public Set<String> allNames() {
            return ImmutableSet.of((Object)this.canonicalName());
        }

        public String canonicalName() {
            return this.rule.simpleTemplateName();
        }

        public boolean supportsSuppressWarnings() {
            return true;
        }

        public Set<Class<? extends Annotation>> customSuppressionAnnotations() {
            return ImmutableSet.of();
        }

        public boolean suppressedByAnyOf(Set<Name> annotations, VisitorState s) {
            return false;
        }
    }
}

