/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class HashMapCodec<K, V>
implements ObjectCodec<HashMap<K, V>> {
    HashMapCodec() {
    }

    @Override
    public Class<HashMap<K, V>> getEncodedClass() {
        return HashMap.class;
    }

    @Override
    public void serialize(SerializationContext context, HashMap<K, V> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(obj.size());
        for (Map.Entry<K, V> entry : obj.entrySet()) {
            context.serialize(entry.getKey(), codedOut);
            context.serialize(entry.getValue(), codedOut);
        }
    }

    @Override
    public LinkedHashMap<K, V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int size = codedIn.readInt32();
        LinkedHashMap result = new LinkedHashMap(4 * size / 3);
        for (int i = 0; i < size; ++i) {
            result.put(context.deserialize(codedIn), context.deserialize(codedIn));
        }
        return result;
    }
}

