/****************************************************************************
*																			*
*					cryptlib Generic Crypto HW Header						*
*					Copyright Peter Gutmann 1998-2020						*
*																			*
****************************************************************************/

/* The access functions that must be provided by each HAL module */

int hwGetCapabilities( const CAPABILITY_INFO **capabilityInfo,
					   int *noCapabilities );
int hwGetMechanisms( const MECHANISM_FUNCTION_INFO **mechanismFunctions, 
					 int *mechanismFunctionCount );
int hwGetRandom( void *buffer, const int length );
int hwCatalogQuery( MESSAGE_CATALOGQUERY_INFO *queryInfo, 
					const CATALOGQUERY_ITEM_TYPE itemType );
int hwGetStorage( void **storageAddr, int *storageSize );
void hwStorageUpdateNotify( const int dataLength );
int hwCloneNotify( int *storageRef );
int hwLookupItem( const void *storageID, const int storageIDlength, 
				  int *storageRef );
int hwDeleteItem( const int storageRef );
int hwInitialise( void );
int hwSelfTest( void );

/* Helper functions in hardware.c that may be used by HAL modules */

CHECK_RETVAL STDC_NONNULL_ARG( ( 1, 3 ) ) \
int setPersonalityMapping( INOUT CONTEXT_INFO *contextInfoPtr, 
						   IN_INT_Z const int keyHandle,
						   OUT_BUFFER_FIXED( storageIDlength ) \
								void *storageID, 
						   IN_LENGTH_FIXED( KEYID_SIZE ) \
								const int storageIDlength );
CHECK_RETVAL STDC_NONNULL_ARG( ( 1, 2 ) ) \
int generatePKCcomponents( INOUT CONTEXT_INFO *contextInfoPtr, 
						   OUT void *keyInfo, 
						   IN_LENGTH_PKC_BITS const int keySizeBits );
CHECK_RETVAL STDC_NONNULL_ARG( ( 1, 2 ) ) \
int getPKCinfo( const CONTEXT_INFO *contextInfoPtr, 
				INOUT void *keyInfo );
CHECK_RETVAL STDC_NONNULL_ARG( ( 1, 2 ) ) \
int setPKCinfo( INOUT CONTEXT_INFO *contextInfoPtr, 
				const void *keyInfo );
CHECK_RETVAL \
int setConvInfo( IN_HANDLE const CRYPT_CONTEXT iCryptContext, 
				 IN_LENGTH_KEY const int keySize );
CHECK_RETVAL STDC_NONNULL_ARG( ( 1 ) ) \
int cleanupHardwareContext( INOUT CONTEXT_INFO *contextInfoPtr );
