/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.LogTableFactor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.SparseMatrixn;
import cc.mallet.types.tests.TestSerializable;
import cc.mallet.util.ArrayUtils;
import cc.mallet.util.Maths;
import cc.mallet.util.Randoms;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestTableFactor
extends TestCase {
    public TestTableFactor(String name) {
        super(name);
    }

    public void testMultiplyMultiplyBy() {
        Variable var = new Variable(4);
        double[] vals = new double[]{2.0, 4.0, 6.0, 8.0};
        double[] vals2 = new double[]{0.5, 0.5, 0.5, 0.5};
        double[] vals3 = new double[]{1.0, 2.0, 3.0, 4.0};
        TableFactor ans = new TableFactor(var, vals3);
        TableFactor ptl1 = new TableFactor(var, vals);
        TableFactor ptl2 = new TableFactor(var, vals2);
        Factor ptl3 = ptl1.multiply(ptl2);
        ptl1.multiplyBy(ptl2);
        TestTableFactor.assertTrue((boolean)ans.almostEquals(ptl1));
        TestTableFactor.assertTrue((boolean)ans.almostEquals(ptl3));
    }

    public void testTblTblPlusEquals() {
        Variable var = new Variable(4);
        double[] vals = new double[]{2.0, 4.0, 6.0, 8.0};
        double[] vals2 = new double[]{0.25, 0.5, 0.75, 1.0};
        double[] vals3 = new double[]{2.25, 4.5, 6.75, 9.0};
        TableFactor ans = new TableFactor(var, vals3);
        TableFactor ptl1 = new TableFactor(var, vals);
        TableFactor ptl2 = new TableFactor(var, vals2);
        ptl1.plusEquals(ptl2);
        TestTableFactor.assertTrue((boolean)ans.almostEquals(ptl1));
    }

    public void testEntropy() {
        Variable v1 = new Variable(2);
        TableFactor ptl = new TableFactor(v1, new double[]{0.3, 0.7});
        double entropy = ptl.entropy();
        TestTableFactor.assertEquals((double)0.61086, (double)entropy, (double)0.001);
        LogTableFactor logFactor = LogTableFactor.makeFromValues(v1, new double[]{0.3, 0.7});
        double entropy2 = logFactor.entropy();
        TestTableFactor.assertEquals((double)0.61086, (double)entropy2, (double)0.001);
    }

    public void ignoreTestSerialization() throws IOException, ClassNotFoundException {
        VarSet varset2;
        Variable v1 = new Variable(2);
        Variable v2 = new Variable(3);
        Variable[] vars = new Variable[]{v1, v2};
        double[] vals = new double[]{2.0, 4.0, 6.0, 3.0, 5.0, 7.0};
        TableFactor ptl = new TableFactor(vars, vals);
        TableFactor ptl2 = (TableFactor)TestSerializable.cloneViaSerialization(ptl);
        VarSet varset1 = ptl.varSet();
        TestTableFactor.assertTrue((!varset1.contains(varset2 = ptl2.varSet()) ? 1 : 0) != 0);
        this.comparePotentialValues(ptl, ptl2);
        TableFactor marg1 = (TableFactor)ptl.marginalize(v1);
        TableFactor marg2 = (TableFactor)ptl2.marginalize(ptl2.findVariable(v1.getLabel()));
        this.comparePotentialValues(marg1, marg2);
    }

    private void comparePotentialValues(TableFactor ptl, TableFactor ptl2) {
        AssignmentIterator it1 = ptl.assignmentIterator();
        AssignmentIterator it2 = ptl2.assignmentIterator();
        while (it1.hasNext()) {
            TestTableFactor.assertTrue((ptl.value(it1) == ptl.value(it2) ? 1 : 0) != 0);
            it1.advance();
            it2.advance();
        }
    }

    public void testSample() {
        int i;
        Variable v = new Variable(3);
        double[] vals = new double[]{1.0, 3.0, 2.0};
        TableFactor ptl = new TableFactor(v, vals);
        int[] sampled = new int[100];
        Randoms r = new Randoms(32423);
        for (int i2 = 0; i2 < sampled.length; ++i2) {
            sampled[i2] = ptl.sampleLocation(r);
        }
        double sum = MatrixOps.sum(vals);
        double[] counts = new double[vals.length];
        for (i = 0; i < vals.length; ++i) {
            counts[i] = ArrayUtils.count(sampled, i);
        }
        MatrixOps.print(counts);
        for (i = 0; i < vals.length; ++i) {
            double prp = counts[i] / (double)sampled.length;
            TestTableFactor.assertEquals((double)(vals[i] / sum), (double)prp, (double)0.1);
        }
    }

    public void testMarginalize() {
        Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
        TableFactor ptl = new TableFactor(vars, new double[]{1.0, 2.0, 3.0, 4.0});
        TableFactor ptl2 = (TableFactor)ptl.marginalize(vars[1]);
        TestTableFactor.assertEquals((String)("FAILURE: Potential has too many vars.\n  " + ptl2), (int)1, (int)ptl2.varSet().size());
        TestTableFactor.assertTrue((String)("FAILURE: Potential does not contain " + vars[1] + ":\n  " + ptl2), (boolean)ptl2.varSet().contains(vars[1]));
        double[] expected = new double[]{4.0, 6.0};
        TestTableFactor.assertTrue((String)("FAILURE: Potential has incorrect values.  Expected " + ArrayUtils.toString(expected) + "was " + ptl2), (boolean)Maths.almostEquals(ptl2.toValueArray(), expected, 1.0E-5));
    }

    public void testMarginalizeOut() {
        Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
        TableFactor ptl = new TableFactor(vars, new double[]{1.0, 2.0, 3.0, 4.0});
        TableFactor ptl2 = (TableFactor)ptl.marginalizeOut(vars[0]);
        TestTableFactor.assertEquals((String)("FAILURE: Potential has too many vars.\n  " + ptl2), (int)1, (int)ptl2.varSet().size());
        TestTableFactor.assertTrue((String)("FAILURE: Potential does not contain " + vars[1] + ":\n  " + ptl2), (boolean)ptl2.varSet().contains(vars[1]));
        double[] expected = new double[]{4.0, 6.0};
        TestTableFactor.assertTrue((String)("FAILURE: Potential has incorrect values.  Expected " + ArrayUtils.toString(expected) + "was " + ptl2), (boolean)Maths.almostEquals(ptl2.toValueArray(), expected, 1.0E-5));
    }

    public void testOneVarSlice() {
        double[] vals = new double[]{0.0, 1.3862943611198906, 0.6931471805599453, 1.791759469228055};
        Variable v1 = new Variable(2);
        Variable v2 = new Variable(2);
        Variable[] vars = new Variable[]{v1, v2};
        TableFactor ptl = new TableFactor(vars, vals);
        Assignment assn = new Assignment(v1, 0);
        TableFactor sliced = (TableFactor)ptl.slice(assn);
        TableFactor expected = new TableFactor(v2, new double[]{1.0, 4.0});
        this.comparePotentialValues(sliced, expected);
    }

    public void testTwoVarSlice() {
        double[] vals = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0};
        Variable v1 = new Variable(2);
        Variable v2 = new Variable(2);
        Variable v3 = new Variable(2);
        Variable[] vars = new Variable[]{v1, v2, v3};
        TableFactor ptl = new TableFactor(vars, vals);
        Assignment assn = new Assignment(v3, 0);
        TableFactor sliced = (TableFactor)ptl.slice(assn);
        TableFactor expected = new TableFactor(new Variable[]{v1, v2}, new double[]{0.0, 2.0, 4.0, 6.0});
        this.comparePotentialValues(sliced, expected);
    }

    public void testMultiVarSlice() {
        double[] vals = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
        Variable v1 = new Variable(2);
        Variable v2 = new Variable(2);
        Variable v3 = new Variable(2);
        Variable v4 = new Variable(2);
        Variable[] vars = new Variable[]{v1, v2, v3, v4};
        TableFactor ptl = new TableFactor(vars, vals);
        System.out.println(ptl);
        Assignment assn = new Assignment(v4, 0);
        TableFactor sliced = (TableFactor)ptl.slice(assn);
        System.out.println(new TableFactor(sliced));
        TableFactor expected = new TableFactor(new Variable[]{v1, v2, v3}, new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0});
        this.comparePotentialValues(sliced, expected);
    }

    public void testLogMultiVarSlice() {
        double[] vals = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
        Variable v1 = new Variable(2);
        Variable v2 = new Variable(2);
        Variable v3 = new Variable(2);
        Variable v4 = new Variable(2);
        Variable[] vars = new Variable[]{v1, v2, v3, v4};
        LogTableFactor ptl = LogTableFactor.makeFromValues(vars, vals);
        System.out.println(ptl.dumpToString());
        Assignment assn = new Assignment(v4, 0);
        LogTableFactor sliced = (LogTableFactor)ptl.slice(assn);
        LogTableFactor expected = LogTableFactor.makeFromValues(new Variable[]{v1, v2, v3}, new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0});
        TestTableFactor.assertTrue((String)("Test failed. Expected: " + expected.dumpToString() + "\nActual: " + sliced.dumpToString()), (boolean)expected.almostEquals(sliced));
    }

    public void testSparseMultiply() {
        Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
        int[] szs = new int[]{2, 2};
        int[] idxs1 = new int[]{0, 1, 3};
        double[] vals1 = new double[]{2.0, 4.0, 8.0};
        int[] idxs2 = new int[]{0, 3};
        double[] vals2 = new double[]{0.5, 0.5};
        double[] vals3 = new double[]{1.0, 0.0, 4.0};
        TableFactor ptl1 = new TableFactor(vars);
        ptl1.setValues(new SparseMatrixn(szs, idxs1, vals1));
        TableFactor ptl2 = new TableFactor(vars);
        ptl2.setValues(new SparseMatrixn(szs, idxs2, vals2));
        TableFactor ans = new TableFactor(vars);
        ans.setValues(new SparseMatrixn(szs, idxs1, vals3));
        Factor ptl3 = ptl1.multiply(ptl2);
        TestTableFactor.assertTrue((String)("Tast failed! Expected: " + ans + " Actual: " + ptl3), (boolean)ans.almostEquals(ptl3));
    }

    public void testSparseDivide() {
        Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
        int[] szs = new int[]{2, 2};
        int[] idxs1 = new int[]{0, 1, 3};
        double[] vals1 = new double[]{2.0, 4.0, 8.0};
        int[] idxs2 = new int[]{0, 3};
        double[] vals2 = new double[]{0.5, 0.5};
        double[] vals3 = new double[]{4.0, 0.0, 16.0};
        TableFactor ptl1 = new TableFactor(vars);
        ptl1.setValues(new SparseMatrixn(szs, idxs1, vals1));
        TableFactor ptl2 = new TableFactor(vars);
        ptl2.setValues(new SparseMatrixn(szs, idxs2, vals2));
        TableFactor ans = new TableFactor(vars);
        ans.setValues(new SparseMatrixn(szs, idxs1, vals3));
        ptl1.divideBy(ptl2);
        TestTableFactor.assertTrue((String)("Tast failed! Expected: " + ans + " Actual: " + ptl1), (boolean)ans.almostEquals(ptl1));
    }

    public void testSparseMarginalize() {
        Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
        int[] szs = new int[]{2, 2};
        int[] idxs1 = new int[]{0, 1, 3};
        double[] vals1 = new double[]{2.0, 4.0, 8.0};
        TableFactor ptl1 = new TableFactor(vars);
        ptl1.setValues(new SparseMatrixn(szs, idxs1, vals1));
        TableFactor ans = new TableFactor(vars[0], new double[]{6.0, 8.0});
        Factor ptl2 = ptl1.marginalize(vars[0]);
        TestTableFactor.assertTrue((String)("Tast failed! Expected: " + ans + " Actual: " + ptl2 + " Orig: " + ptl1), (boolean)ans.almostEquals(ptl2));
    }

    public void testSparseExtractMax() {
        Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
        int[] szs = new int[]{2, 2};
        int[] idxs1 = new int[]{0, 1, 3};
        double[] vals1 = new double[]{2.0, 4.0, 8.0};
        TableFactor ptl1 = new TableFactor(vars);
        ptl1.setValues(new SparseMatrixn(szs, idxs1, vals1));
        TableFactor ans = new TableFactor(vars[0], new double[]{4.0, 8.0});
        Factor ptl2 = ptl1.extractMax(vars[0]);
        TestTableFactor.assertTrue((String)("Tast failed! Expected: " + ans + " Actual: " + ptl2 + "Orig: " + ptl1), (boolean)ans.almostEquals(ptl2));
    }

    public void testLogSample() {
        Variable v = new Variable(2);
        double[] vals = new double[]{-30.0, 0.0};
        LogTableFactor ptl = LogTableFactor.makeFromLogValues(v, vals);
        int idx = ptl.sampleLocation(new Randoms(43));
        TestTableFactor.assertEquals((int)1, (int)idx);
    }

    public void testExp() {
        Variable var = new Variable(4);
        double[] vals = new double[]{2.0, 4.0, 6.0, 8.0};
        double[] vals3 = new double[]{4.0, 16.0, 36.0, 64.0};
        TableFactor ans = new TableFactor(var, vals3);
        TableFactor ptl1 = new TableFactor(var, vals);
        ptl1.exponentiate(2.0);
        TestTableFactor.assertTrue((String)("Error: expected " + ans.dumpToString() + " but was " + ptl1.dumpToString()), (boolean)ptl1.almostEquals(ans));
    }

    public void testPlusEquals() {
        Variable var = new Variable(4);
        double[] vals = new double[]{2.0, 4.0, 6.0, 8.0};
        TableFactor factor = new TableFactor(var, vals);
        factor.plusEquals(0.1);
        double[] expected = new double[]{2.1, 4.1, 6.1, 8.1};
        TableFactor ans = new TableFactor(var, expected);
        TestTableFactor.assertTrue((String)("Error: expected " + ans.dumpToString() + " but was " + factor.dumpToString()), (boolean)factor.almostEquals(ans));
    }

    public void testMultiplyAll() {
        for (int rep = 0; rep < 100; ++rep) {
            Variable v1 = new Variable(2);
            Variable v2 = new Variable(2);
            Variable[] vars = new Variable[]{v1, v2};
            double[] vals = new double[]{2.0, 4.0, 6.0, 8.0};
            double[] vals2 = new double[]{0.5, 0.5, 0.5, 0.5};
            double[] vals3 = new double[]{1.0, 2.0, 3.0, 4.0};
            TableFactor ans = new TableFactor(vars, vals3);
            TableFactor ptl1 = new TableFactor(vars, vals);
            TableFactor ptl2 = new TableFactor(vars, vals2);
            DiscreteFactor ptl3 = TableFactor.multiplyAll(new Factor[]{ptl1, ptl2});
            VarSet vs = ptl3.varSet();
            for (int i = 0; i < vars.length; ++i) {
                TestTableFactor.assertEquals((Object)vars[i], (Object)vs.get(i));
            }
            TestTableFactor.assertTrue((boolean)ans.almostEquals(ptl3));
        }
    }

    public void testExpandToContain() {
        Variable v1 = new Variable(2);
        Variable v2 = new Variable(2);
        Variable v3 = new Variable(2);
        Variable[] vars = new Variable[]{v1, v2};
        double[] vals = new double[]{2.0, 4.0, 6.0, 8.0};
        double[] vals2 = new double[]{0.5, 0.5};
        TableFactor f1 = new TableFactor(vars, vals);
        TableFactor f2 = new TableFactor(v3, vals2);
        f1.multiplyBy(f2);
        Variable[] allV = new Variable[]{v1, v2, v3};
        double[] exp = new double[]{1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0};
        TableFactor ans = new TableFactor(allV, exp);
        System.out.println(f1.dumpToString());
        System.out.println(ans.dumpToString());
        TestTableFactor.assertTrue((boolean)ans.almostEquals(f1));
    }

    public static Test suite() {
        return new TestSuite(TestTableFactor.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestTableFactor(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestTableFactor.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

