/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.LogTableFactor;
import cc.mallet.grmm.types.ParameterizedFactor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Randoms;

public class BoltzmannUnaryFactor
extends AbstractFactor
implements ParameterizedFactor {
    private Variable theta;
    private Variable var;

    public BoltzmannUnaryFactor(Variable var, Variable alpha) {
        super(BoltzmannUnaryFactor.combineVariables(alpha, var));
        this.theta = alpha;
        this.var = var;
        if (var.getNumOutcomes() != 2) {
            throw new IllegalArgumentException("Discrete variable " + var + " in BoltzmannUnary must be binary.");
        }
        if (!alpha.isContinuous()) {
            throw new IllegalArgumentException("Parameter " + alpha + " in BoltzmannUnary must be continuous.");
        }
    }

    private static VarSet combineVariables(Variable alpha, Variable var) {
        HashVarSet ret = new HashVarSet();
        ret.add(alpha);
        ret.add(var);
        return ret;
    }

    protected Factor extractMaxInternal(VarSet varSet) {
        throw new UnsupportedOperationException();
    }

    protected double lookupValueInternal(int i) {
        throw new UnsupportedOperationException();
    }

    protected Factor marginalizeInternal(VarSet varsToKeep) {
        throw new UnsupportedOperationException();
    }

    public double value(AssignmentIterator it) {
        Assignment assn = it.assignment();
        Factor tbl = this.sliceForAlpha(assn);
        return tbl.value(assn);
    }

    private Factor sliceForAlpha(Assignment assn) {
        double alph = assn.getDouble(this.theta);
        double[] vals = new double[]{0.0, -alph};
        return LogTableFactor.makeFromLogValues(this.var, vals);
    }

    public Factor normalize() {
        throw new UnsupportedOperationException();
    }

    public Assignment sample(Randoms r) {
        throw new UnsupportedOperationException();
    }

    public double logValue(AssignmentIterator it) {
        return Math.log(this.value(it));
    }

    public Factor slice(Assignment assn) {
        Factor alphSlice = this.sliceForAlpha(assn);
        return alphSlice.slice(assn);
    }

    public String dumpToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Potts Alpha=");
        buf.append(this.theta);
        buf.append(this.var);
        return buf.toString();
    }

    public double sumGradLog(Factor q, Variable param, Assignment paramAssn) {
        if (param != this.theta) {
            throw new IllegalArgumentException();
        }
        Factor q_xs = q.marginalize(this.var);
        Assignment assn = new Assignment(this.var, 1);
        return -q_xs.value(assn);
    }

    public Factor duplicate() {
        return new BoltzmannUnaryFactor(this.var, this.theta);
    }

    public boolean almostEquals(Factor p, double epsilon) {
        return this.equals(p);
    }

    public boolean isNaN() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltzmannUnaryFactor that = (BoltzmannUnaryFactor)o;
        if (this.theta != null ? !this.theta.equals(that.theta) : that.theta != null) {
            return false;
        }
        return !(this.var != null ? !this.var.equals(that.var) : that.var != null);
    }

    public int hashCode() {
        int result = this.theta != null ? this.theta.hashCode() : 0;
        result = 29 * result + (this.var != null ? this.var.hashCode() : 0);
        return result;
    }
}

