/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize;

import cc.mallet.optimize.BackTrackLineSearch;
import cc.mallet.optimize.LineOptimizer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.optimize.OptimizerEvaluator;
import cc.mallet.optimize.tests.TestOptimizable;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class ConjugateGradient
implements Optimizer {
    private static Logger logger = MalletLogger.getLogger(ConjugateGradient.class.getName());
    boolean converged = false;
    Optimizable.ByGradientValue optimizable;
    LineOptimizer.ByGradient lineMaximizer;
    double initialStepSize = 0.01;
    double tolerance = 1.0E-4;
    int maxIterations = 1000;
    final double eps = 1.0E-10;
    private OptimizerEvaluator.ByGradient eval;
    double fp;
    double gg;
    double gam;
    double dgg;
    double step;
    double fret;
    double[] xi;
    double[] g;
    double[] h;
    int j;
    int iterations;

    public ConjugateGradient(Optimizable.ByGradientValue function, double initialStepSize) {
        this.initialStepSize = initialStepSize;
        this.optimizable = function;
        this.lineMaximizer = new BackTrackLineSearch(function);
    }

    public ConjugateGradient(Optimizable.ByGradientValue function) {
        this(function, 0.01);
    }

    public Optimizable getOptimizable() {
        return this.optimizable;
    }

    public boolean isConverged() {
        return this.converged;
    }

    public void setEvaluator(OptimizerEvaluator.ByGradient eval) {
        this.eval = eval;
    }

    public void setLineMaximizer(LineOptimizer.ByGradient lineMaximizer) {
        this.lineMaximizer = lineMaximizer;
    }

    public void setInitialStepSize(double initialStepSize) {
        this.initialStepSize = initialStepSize;
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public double getStepSize() {
        return this.step;
    }

    public boolean optimize() {
        return this.optimize(this.maxIterations);
    }

    public void setTolerance(double t) {
        this.tolerance = t;
    }

    public boolean optimize(int numIterations) {
        if (this.converged) {
            return true;
        }
        int n = this.optimizable.getNumParameters();
        double prevStepSize = this.initialStepSize;
        boolean searchingGradient = true;
        if (this.xi == null) {
            this.fp = this.optimizable.getValue();
            this.xi = new double[n];
            this.g = new double[n];
            this.h = new double[n];
            this.optimizable.getValueGradient(this.xi);
            System.arraycopy(this.xi, 0, this.g, 0, n);
            System.arraycopy(this.xi, 0, this.h, 0, n);
            this.step = this.initialStepSize;
            this.iterations = 0;
        }
        for (int iterationCount = 0; iterationCount < numIterations; ++iterationCount) {
            double xj;
            logger.info("ConjugateGradient: At iteration " + this.iterations + ", cost = " + this.fp);
            try {
                prevStepSize = this.step;
                this.step = this.lineMaximizer.optimize(this.xi, this.step);
            }
            catch (IllegalArgumentException e) {
                System.out.println("ConjugateGradient caught " + e.toString());
                TestOptimizable.testValueAndGradientCurrentParameters(this.optimizable);
                TestOptimizable.testValueAndGradientInDirection(this.optimizable, this.xi);
            }
            if (this.step == 0.0) {
                if (searchingGradient) {
                    System.err.println("ConjugateGradient converged: Line maximizer got step 0 in gradient direction.  Gradient absNorm=" + MatrixOps.absNorm(this.xi));
                    this.converged = true;
                    return true;
                }
                System.err.println("Line maximizer got step 0.  Probably pointing up hill.  Resetting to gradient.  Gradient absNorm=" + MatrixOps.absNorm(this.xi));
                this.fp = this.optimizable.getValue();
                this.optimizable.getValueGradient(this.xi);
                searchingGradient = true;
                System.arraycopy(this.xi, 0, this.g, 0, n);
                System.arraycopy(this.xi, 0, this.h, 0, n);
                this.step = prevStepSize;
                continue;
            }
            this.fret = this.optimizable.getValue();
            if (2.0 * Math.abs(this.fret - this.fp) <= this.tolerance * (Math.abs(this.fret) + Math.abs(this.fp) + 1.0E-10)) {
                System.out.println("ConjugateGradient converged: old value= " + this.fp + " new value= " + this.fret + " tolerance=" + this.tolerance);
                this.converged = true;
                return true;
            }
            this.fp = this.fret;
            this.optimizable.getValueGradient(this.xi);
            logger.info("Gradient infinityNorm = " + MatrixOps.infinityNorm(this.xi));
            if (MatrixOps.infinityNorm(this.xi) < this.tolerance) {
                System.err.println("ConjugateGradient converged: maximum gradient component " + MatrixOps.infinityNorm(this.xi) + ", less than " + this.tolerance);
                this.converged = true;
                return true;
            }
            this.gg = 0.0;
            this.dgg = 0.0;
            this.j = 0;
            while (this.j < this.xi.length) {
                double gj = this.g[this.j];
                this.gg += gj * gj;
                xj = -this.xi[this.j];
                this.dgg = (xj + gj) * xj;
                ++this.j;
            }
            if (this.gg == 0.0) {
                System.err.println("ConjugateGradient converged: gradient is exactly zero.");
                this.converged = true;
                return true;
            }
            this.gam = this.dgg / this.gg;
            this.j = 0;
            while (this.j < this.xi.length) {
                this.g[this.j] = xj = this.xi[this.j];
                double hj = this.h[this.j];
                this.h[this.j] = hj = xj + this.gam * hj;
                ++this.j;
            }
            assert (!MatrixOps.isNaN(this.h));
            MatrixOps.set(this.xi, this.h);
            searchingGradient = false;
            ++this.iterations;
            if (this.iterations > this.maxIterations) {
                System.err.println("Too many iterations in ConjugateGradient.java");
                this.converged = true;
                return true;
            }
            if (this.eval == null) continue;
            this.eval.evaluate(this.optimizable, this.iterations);
        }
        return false;
    }

    public void reset() {
        this.xi = null;
    }
}

