/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize;

import cc.mallet.optimize.Optimizable;
import cc.mallet.types.MatrixOps;
import java.util.ArrayList;

public class OptimizableCollection {

    public class ByGradientValue
    implements Optimizable.ByGradientValue {
        ArrayList<Optimizable.ByGradientValue> optimizables;

        public ByGradientValue(Optimizable.ByGradientValue ... ops) {
            this.optimizables = new ArrayList(ops.length);
            for (Optimizable.ByGradientValue o : ops) {
                this.optimizables.add(o);
            }
        }

        public void getValueGradient(double[] buffer) {
            double[] b2 = new double[buffer.length];
            for (Optimizable.ByGradientValue o : this.optimizables) {
                MatrixOps.setAll(b2, 0.0);
                o.getValueGradient(b2);
                MatrixOps.plusEquals(buffer, b2);
            }
        }

        public double getValue() {
            double ret = 0.0;
            for (Optimizable.ByGradientValue o : this.optimizables) {
                ret += o.getValue();
            }
            return ret;
        }

        public int getNumParameters() {
            return this.optimizables.get(0).getNumParameters();
        }

        public double getParameter(int index) {
            return this.optimizables.get(0).getParameter(index);
        }

        public void getParameters(double[] buffer) {
            this.optimizables.get(0).getParameters(buffer);
        }

        public void setParameter(int index, double value) {
            this.optimizables.get(0).setParameter(index, value);
        }

        public void setParameters(double[] params) {
            this.optimizables.get(0).setParameters(params);
        }
    }
}

