/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.util.BitSet;
import java.util.Random;

public class Randoms
extends Random {
    private double nextGaussian;
    private boolean haveNextGaussian = false;

    public Randoms(int seed) {
        super(seed);
    }

    public Randoms() {
    }

    public synchronized int nextPoisson(double lambda) {
        int v = -1;
        double l = Math.exp(-lambda);
        double p = 1.0;
        while (p >= l) {
            p *= this.nextUniform();
            ++v;
        }
        return v;
    }

    public synchronized int nextPoisson() {
        return this.nextPoisson(1.0);
    }

    public synchronized boolean nextBoolean() {
        return (this.next(32) & 0x8000) != 0;
    }

    public synchronized boolean nextBoolean(double p) {
        double u = this.nextUniform();
        return u < p;
    }

    public synchronized BitSet nextBitSet(int size, double p) {
        BitSet bs = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            if (!this.nextBoolean(p)) continue;
            bs.set(i);
        }
        return bs;
    }

    public synchronized double nextUniform() {
        long l = ((long)this.next(26) << 27) + (long)this.next(27);
        return (double)l / 9.007199254740992E15;
    }

    public synchronized double nextUniform(double a, double b) {
        return a + (b - a) * this.nextUniform();
    }

    public synchronized int nextDiscrete(double[] a) {
        double b = 0.0;
        double r = this.nextUniform();
        for (int i = 0; i < a.length; ++i) {
            if (!((b += a[i]) > r)) continue;
            return i;
        }
        return a.length - 1;
    }

    public synchronized int nextDiscrete(double[] a, double sum) {
        double b = 0.0;
        double r = this.nextUniform() * sum;
        for (int i = 0; i < a.length; ++i) {
            if (!((b += a[i]) > r)) continue;
            return i;
        }
        return a.length - 1;
    }

    public synchronized double nextGaussian() {
        if (!this.haveNextGaussian) {
            double x2;
            double v1 = this.nextUniform();
            double v2 = this.nextUniform();
            double x1 = Math.sqrt(-2.0 * Math.log(v1)) * Math.cos(Math.PI * 2 * v2);
            this.nextGaussian = x2 = Math.sqrt(-2.0 * Math.log(v1)) * Math.sin(Math.PI * 2 * v2);
            this.haveNextGaussian = true;
            return x1;
        }
        this.haveNextGaussian = false;
        return this.nextGaussian;
    }

    public synchronized double nextGaussian(double m, double s2) {
        return this.nextGaussian() * Math.sqrt(s2) + m;
    }

    public synchronized double nextGamma() {
        return this.nextGamma(1.0, 1.0, 0.0);
    }

    public synchronized double nextGamma(double alpha) {
        return this.nextGamma(alpha, 1.0, 0.0);
    }

    public synchronized double oldNextGamma(int ia) {
        double x;
        assert (ia >= 1);
        if (ia < 6) {
            x = 1.0;
            for (int j = 1; j <= ia; ++j) {
                x *= this.nextUniform();
            }
            x = -Math.log(x);
        } else {
            while (true) {
                double v2;
                double v1;
                if ((v1 = 2.0 * this.nextUniform() - 1.0) * v1 + (v2 = 2.0 * this.nextUniform() - 1.0) * v2 > 1.0) {
                    continue;
                }
                double y = v2 / v1;
                double am = ia - 1;
                double s = Math.sqrt(2.0 * am + 1.0);
                x = s * y + am;
                if (x <= 0.0) continue;
                double e = (1.0 + y * y) * Math.exp(am * Math.log(x / am) - s * y);
                if (!(this.nextUniform() > e)) break;
            }
        }
        return x;
    }

    public synchronized double nextGamma(double alpha, double beta) {
        return this.nextGamma(alpha, beta, 0.0);
    }

    public synchronized double nextGamma(double alpha, double beta, double lambda) {
        double gamma = 0.0;
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("alpha and beta must be strictly positive.");
        }
        if (alpha < 1.0) {
            boolean flag = false;
            double b = 1.0 + alpha * Math.exp(-1.0);
            while (!flag) {
                double p = b * this.nextUniform();
                if (p > 1.0) {
                    gamma = -Math.log((b - p) / alpha);
                    if (!(this.nextUniform() <= Math.pow(gamma, alpha - 1.0))) continue;
                    flag = true;
                    continue;
                }
                gamma = Math.pow(p, 1.0 / alpha);
                if (!(this.nextUniform() <= Math.exp(-gamma))) continue;
                flag = true;
            }
        } else if (alpha == 1.0) {
            gamma = -Math.log(this.nextUniform());
        } else {
            double b = alpha - 1.0;
            double c = 3.0 * alpha - 0.75;
            boolean accept = false;
            while (!accept) {
                double z;
                double u = this.nextUniform();
                double v = this.nextUniform();
                double w = u * (1.0 - u);
                double y = Math.sqrt(c / w) * (u - 0.5);
                gamma = b + y;
                if (!(gamma >= 0.0) || (accept = (z = 64.0 * w * w * w * v * v) <= 1.0 - 2.0 * y * y / gamma)) continue;
                accept = Math.log(z) <= 2.0 * (b * Math.log(gamma / b) - y);
            }
        }
        return beta * gamma + lambda;
    }

    public synchronized double nextExp() {
        return this.nextGamma(1.0, 1.0, 0.0);
    }

    public synchronized double nextExp(double beta) {
        return this.nextGamma(1.0, beta, 0.0);
    }

    public synchronized double nextExp(double beta, double lambda) {
        return this.nextGamma(1.0, beta, lambda);
    }

    public synchronized double nextChiSq() {
        return this.nextGamma(0.5, 2.0, 0.0);
    }

    public synchronized double nextChiSq(int df) {
        return this.nextGamma(0.5 * (double)df, 2.0, 0.0);
    }

    public synchronized double nextChiSq(int df, double lambda) {
        return this.nextGamma(0.5 * (double)df, 2.0, lambda);
    }

    public synchronized double nextBeta(double alpha, double beta) {
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("alpha and beta must be strictly positive.");
        }
        if (alpha == 1.0 && beta == 1.0) {
            return this.nextUniform();
        }
        if (alpha >= 1.0 && beta >= 1.0) {
            double A = alpha - 1.0;
            double B = beta - 1.0;
            double C = A + B;
            double L = C * Math.log(C);
            double mu = A / C;
            double sigma = 0.5 / Math.sqrt(C);
            double y = this.nextGaussian();
            double x = sigma * y + mu;
            while (x < 0.0 || x > 1.0) {
                y = this.nextGaussian();
                x = sigma * y + mu;
            }
            double u = this.nextUniform();
            while (Math.log(u) >= A * Math.log(x / A) + B * Math.log((1.0 - x) / B) + L + 0.5 * y * y) {
                y = this.nextGaussian();
                x = sigma * y + mu;
                while (x < 0.0 || x > 1.0) {
                    y = this.nextGaussian();
                    x = sigma * y + mu;
                }
                u = this.nextUniform();
            }
            return x;
        }
        double v1 = Math.pow(this.nextUniform(), 1.0 / alpha);
        double v2 = Math.pow(this.nextUniform(), 1.0 / beta);
        while (v1 + v2 > 1.0) {
            v1 = Math.pow(this.nextUniform(), 1.0 / alpha);
            v2 = Math.pow(this.nextUniform(), 1.0 / beta);
        }
        return v1 / (v1 + v2);
    }

    @Deprecated
    public Random asJavaRandom() {
        return new Random(){

            protected int next(int bits) {
                return Randoms.this.next(bits);
            }
        };
    }

    public static void main(String[] args) {
        int i;
        Randoms r = new Randoms();
        int resolution = 60;
        int[] histogram1 = new int[60];
        int[] histogram2 = new int[60];
        int scale = 10;
        for (i = 0; i < 10000; ++i) {
            double x = 4.0;
            int index1 = (int)(r.nextGamma(x) / (double)scale * 60.0) % 60;
            int index2 = (int)(r.oldNextGamma((int)x) / (double)scale * 60.0) % 60;
            int n = index1;
            histogram1[n] = histogram1[n] + 1;
            int n2 = index2;
            histogram2[n2] = histogram2[n2] + 1;
        }
        for (i = 0; i < 60; ++i) {
            int y;
            for (y = 0; y < histogram1[i] / scale; ++y) {
                System.out.print("*");
            }
            System.out.print("\n");
            for (y = 0; y < histogram2[i] / scale; ++y) {
                System.out.print("-");
            }
            System.out.print("\n");
        }
    }
}

