/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class CreateIndexResponse
extends AcknowledgedResponse
implements ToXContentObject {
    private static final String SHARDS_ACKNOWLEDGED = "shards_acknowledged";
    private static final String INDEX = "index";
    private static final ParseField SHARDS_ACKNOWLEDGED_PARSER = new ParseField("shards_acknowledged", new String[0]);
    private static final ParseField INDEX_PARSER = new ParseField("index", new String[0]);
    private static final ConstructingObjectParser<CreateIndexResponse, Void> PARSER = new ConstructingObjectParser("create_index", true, args -> new CreateIndexResponse((Boolean)args[0], (Boolean)args[1], (String)args[2]));
    private boolean shardsAcked;
    private String index;

    protected CreateIndexResponse() {
    }

    protected CreateIndexResponse(boolean acknowledged, boolean shardsAcked, String index) {
        super(acknowledged);
        assert (acknowledged || !shardsAcked);
        this.shardsAcked = shardsAcked;
        this.index = index;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.readAcknowledged(in);
        this.shardsAcked = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_5_6_0)) {
            this.index = in.readString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeAcknowledged(out);
        out.writeBoolean(this.shardsAcked);
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeString(this.index);
        }
    }

    public boolean isShardsAcked() {
        return this.shardsAcked;
    }

    public String index() {
        return this.index;
    }

    public void addCustomFields(XContentBuilder builder) throws IOException {
        builder.field(SHARDS_ACKNOWLEDGED, this.isShardsAcked());
        builder.field(INDEX, this.index());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addAcknowledgedField(builder);
        this.addCustomFields(builder);
        builder.endObject();
        return builder;
    }

    public static CreateIndexResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    static {
        CreateIndexResponse.declareAcknowledgedField(PARSER);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), SHARDS_ACKNOWLEDGED_PARSER, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.text(), INDEX_PARSER, ObjectParser.ValueType.STRING);
    }
}

