/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;
import org.gradle.internal.classloader.TransformingClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

class GroovyCompileTransformingClassLoader
extends TransformingClassLoader {
    private static final String ANNOTATION_DESCRIPTOR = Type.getType(GroovyASTTransformationClass.class).getDescriptor();

    public GroovyCompileTransformingClassLoader(ClassLoader parent, ClassPath classPath) {
        super(parent, classPath);
    }

    protected byte[] transform(String className, byte[] bytes) {
        ClassReader classReader = new ClassReader(bytes);
        AnnotationDetector detector = new AnnotationDetector();
        classReader.accept((ClassVisitor)detector, 3);
        if (!detector.found) {
            return bytes;
        }
        ClassWriter classWriter = new ClassWriter(0);
        classReader.accept((ClassVisitor)new TransformingAdapter(classWriter), 0);
        bytes = classWriter.toByteArray();
        return bytes;
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private static class TransformingAdapter
    extends ClassVisitor {
        public TransformingAdapter(ClassWriter classWriter) {
            super(393216, (ClassVisitor)classWriter);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(ANNOTATION_DESCRIPTOR)) {
                return new AnnotationTransformingVisitor(super.visitAnnotation(desc, visible));
            }
            return super.visitAnnotation(desc, visible);
        }

        private static class AnnotationTransformingVisitor
        extends AnnotationVisitor {
            private final List<String> names = new ArrayList<String>();

            public AnnotationTransformingVisitor(AnnotationVisitor annotationVisitor) {
                super(393216, annotationVisitor);
            }

            public AnnotationVisitor visitArray(String name) {
                if (name.equals("classes")) {
                    return new AnnotationVisitor(393216){

                        public void visit(String name, Object value) {
                            Type type = (Type)value;
                            AnnotationTransformingVisitor.this.names.add(type.getClassName());
                        }
                    };
                }
                if (name.equals("value")) {
                    return new AnnotationVisitor(393216){

                        public void visit(String name, Object value) {
                            String type = (String)value;
                            AnnotationTransformingVisitor.this.names.add(type);
                        }
                    };
                }
                return super.visitArray(name);
            }

            public void visitEnd() {
                if (!this.names.isEmpty()) {
                    AnnotationVisitor visitor = super.visitArray("value");
                    for (String name : this.names) {
                        visitor.visit(null, (Object)name);
                    }
                    visitor.visitEnd();
                }
                super.visitEnd();
            }
        }
    }

    private static class AnnotationDetector
    extends ClassVisitor {
        private boolean found;

        private AnnotationDetector() {
            super(393216);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(ANNOTATION_DESCRIPTOR)) {
                this.found = true;
            }
            return null;
        }
    }
}

