/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import groovy.lang.GString;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DeclaredTaskInputFileProperty;
import org.gradle.api.internal.tasks.DeclaredTaskInputProperty;
import org.gradle.api.internal.tasks.DefaultTaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertySpec;
import org.gradle.api.internal.tasks.LenientTaskInputsDeprecationSupport;
import org.gradle.api.internal.tasks.StaticValue;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.tasks.TaskInputPropertyBuilder;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskInputs
implements TaskInputsInternal {
    private final FileCollection allInputFiles;
    private final FileCollection allSourceFiles;
    private final FileResolver resolver;
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private final Map<String, PropertyValue> properties = new HashMap<String, PropertyValue>();
    private final List<DeclaredTaskInputFileProperty> declaredFileProperties = Lists.newArrayList();
    private final TaskInputs deprecatedThis;
    private ImmutableSortedSet<TaskInputFilePropertySpec> fileProperties;
    private static final ValidationAction INPUT_FILE_VALIDATOR = new ValidationAction(){

        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
            File file = DefaultTaskInputs.toFile(context, value);
            if (!file.exists()) {
                context.recordValidationMessage(severity, String.format("File '%s' specified for property '%s' does not exist.", file, propertyName));
            } else if (!file.isFile()) {
                context.recordValidationMessage(severity, String.format("File '%s' specified for property '%s' is not a file.", file, propertyName));
            }
        }
    };
    private static final ValidationAction INPUT_DIRECTORY_VALIDATOR = new ValidationAction(){

        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
            File directory = DefaultTaskInputs.toDirectory(context, value);
            if (!directory.exists()) {
                context.recordValidationMessage(severity, String.format("Directory '%s' specified for property '%s' does not exist.", directory, propertyName));
            } else if (!directory.isDirectory()) {
                context.recordValidationMessage(severity, String.format("Directory '%s' specified for property '%s' is not a directory.", directory, propertyName));
            }
        }
    };
    private static final ValidationAction RUNTIME_INPUT_FILE_VALIDATOR = DefaultTaskInputs.wrapRuntimeApiValidator("file", INPUT_FILE_VALIDATOR);
    private static final ValidationAction RUNTIME_INPUT_DIRECTORY_VALIDATOR = DefaultTaskInputs.wrapRuntimeApiValidator("dir", INPUT_DIRECTORY_VALIDATOR);

    public DefaultTaskInputs(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.task = task;
        this.taskMutator = taskMutator;
        String taskName = task.getName();
        this.allInputFiles = new TaskInputUnionFileCollection(taskName, "input", false, this.declaredFileProperties);
        this.allSourceFiles = new TaskInputUnionFileCollection(taskName, "source", true, this.declaredFileProperties);
        this.deprecatedThis = new LenientTaskInputsDeprecationSupport(this);
    }

    public boolean getHasInputs() {
        return !this.declaredFileProperties.isEmpty() || !this.properties.isEmpty();
    }

    public FileCollection getFiles() {
        return this.allInputFiles;
    }

    @Override
    public ImmutableSortedSet<TaskInputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            TaskPropertyUtils.ensurePropertiesHaveNames(this.declaredFileProperties);
            this.fileProperties = TaskPropertyUtils.collectFileProperties("input", this.declaredFileProperties.iterator());
        }
        return this.fileProperties;
    }

    public TaskInputFilePropertyBuilderInternal files(final Object ... paths) {
        return this.taskMutator.mutate("TaskInputs.files(Object...)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                return DefaultTaskInputs.this.files(new StaticValue(DefaultTaskInputs.unpackVarargs(paths)));
            }
        });
    }

    private static Object unpackVarargs(Object[] args) {
        if (args.length == 1) {
            return args[0];
        }
        return args;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal files(ValidatingValue paths) {
        return this.addSpec(paths, ValidationAction.NO_OP);
    }

    public TaskInputFilePropertyBuilderInternal file(final Object path) {
        return this.taskMutator.mutate("TaskInputs.file(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                return DefaultTaskInputs.this.fileInternal(new StaticValue(path), RUNTIME_INPUT_FILE_VALIDATOR);
            }
        });
    }

    @Override
    public TaskInputFilePropertyBuilderInternal file(ValidatingValue value) {
        return this.fileInternal(value, INPUT_FILE_VALIDATOR);
    }

    private TaskInputFilePropertyBuilderInternal fileInternal(ValidatingValue value, ValidationAction validator) {
        return this.addSpec(value, validator);
    }

    public TaskInputFilePropertyBuilderInternal dir(final Object dirPath) {
        return this.taskMutator.mutate("TaskInputs.dir(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                return DefaultTaskInputs.this.dir(new StaticValue(dirPath), RUNTIME_INPUT_DIRECTORY_VALIDATOR);
            }
        });
    }

    @Override
    public TaskInputFilePropertyBuilderInternal dir(ValidatingValue dirPath) {
        return this.dir(dirPath, INPUT_DIRECTORY_VALIDATOR);
    }

    private TaskInputFilePropertyBuilderInternal dir(ValidatingValue dirPath, ValidationAction validator) {
        FileTreeInternal fileTree = this.resolver.resolveFilesAsTree(dirPath);
        return this.addSpec(new FileTreeValue(dirPath, fileTree), validator);
    }

    public boolean getHasSourceFiles() {
        for (DeclaredTaskInputFileProperty propertySpec : this.declaredFileProperties) {
            if (!propertySpec.isSkipWhenEmpty()) continue;
            return true;
        }
        return false;
    }

    public FileCollection getSourceFiles() {
        return this.allSourceFiles;
    }

    @Override
    public void validate(TaskValidationContext context) {
        TaskPropertyUtils.ensurePropertiesHaveNames(this.declaredFileProperties);
        for (PropertyValue propertyValue : this.properties.values()) {
            propertyValue.getPropertySpec().validate(context);
        }
        for (DeclaredTaskInputFileProperty property : this.declaredFileProperties) {
            property.validate(context);
        }
    }

    private TaskInputFilePropertyBuilderInternal addSpec(ValidatingValue paths, ValidationAction validationAction) {
        DefaultTaskInputFilePropertySpec spec = new DefaultTaskInputFilePropertySpec(this.task.getName(), this.resolver, paths, validationAction);
        this.declaredFileProperties.add(spec);
        return spec;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> actualProperties = new HashMap<String, Object>();
        for (PropertyValue property : this.properties.values()) {
            String propertyName = property.resolveName();
            try {
                Object value = this.prepareValue(property.resolveValue());
                actualProperties.put(propertyName, value);
            }
            catch (Exception ex) {
                throw new InvalidUserDataException(String.format("Error while evaluating property '%s' of %s", propertyName, this.task), (Throwable)ex);
            }
        }
        return actualProperties;
    }

    @Nullable
    private Object prepareValue(@Nullable Object value) {
        while (value instanceof Callable) {
            Callable callable = (Callable)value;
            value = GUtil.uncheckedCall((Callable)callable);
        }
        if (value instanceof FileCollection) {
            FileCollection fileCollection = (FileCollection)value;
            return fileCollection.getFiles();
        }
        return DefaultTaskInputs.avoidGString(value);
    }

    @Nullable
    private static Object avoidGString(@Nullable Object value) {
        return value instanceof GString ? value.toString() : value;
    }

    public TaskInputPropertyBuilder property(final String name, final @Nullable Object value) {
        return this.taskMutator.mutate("TaskInputs.property(String, Object)", new Callable<TaskInputPropertyBuilder>(){

            @Override
            public TaskInputPropertyBuilder call() {
                return DefaultTaskInputs.this.property(name, new StaticValue(value));
            }
        });
    }

    public TaskInputs properties(final Map<String, ?> newProps) {
        this.taskMutator.mutate("TaskInputs.properties(Map)", new Runnable(){

            public void run() {
                for (Map.Entry entry : newProps.entrySet()) {
                    DefaultTaskInputs.this.property((String)entry.getKey(), new StaticValue(entry.getValue()));
                }
            }
        });
        return this.deprecatedThis;
    }

    @Override
    public TaskInputPropertyBuilder property(String name, ValidatingValue value) {
        DeclaredTaskInputProperty spec;
        PropertyValue propertyValue = this.properties.get(name);
        if (propertyValue instanceof SimplePropertyValue) {
            spec = propertyValue.getPropertySpec();
            propertyValue.setValue(value);
        } else {
            spec = new DefaultTaskInputPropertySpec(this, name, value);
            propertyValue = new SimplePropertyValue(spec, value);
            this.properties.put(name, propertyValue);
        }
        return spec;
    }

    @Override
    public TaskInputPropertyBuilder nested(String name, ValidatingValue value) {
        DeclaredTaskInputProperty spec;
        PropertyValue propertyValue = this.properties.get(name);
        if (propertyValue instanceof NestedBeanTypePropertyValue) {
            spec = propertyValue.getPropertySpec();
            propertyValue.setValue(value);
        } else {
            spec = new DefaultTaskInputPropertySpec(this, name, value);
            propertyValue = new NestedBeanTypePropertyValue(spec, value);
            this.properties.put(name, propertyValue);
        }
        return spec;
    }

    private static ValidationAction wrapRuntimeApiValidator(final String method, final ValidationAction validator) {
        return new ValidationAction(){

            public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
                try {
                    validator.validate(propertyName, value, context, severity);
                }
                catch (UnsupportedNotationException ex) {
                    DeprecationLogger.nagUserOfDeprecated((String)("Using TaskInputs." + method + "() with something that doesn't resolve to a File object"), (String)"Use TaskInputs.files() instead");
                }
            }
        };
    }

    private static File toFile(TaskValidationContext context, Object value) {
        return context.getResolver().resolve(value);
    }

    private static File toDirectory(TaskValidationContext context, Object value) {
        if (value instanceof ConfigurableFileTree) {
            return ((ConfigurableFileTree)value).getDir();
        }
        return DefaultTaskInputs.toFile(context, value);
    }

    private static class FileTreeValue
    implements ValidatingValue {
        private final ValidatingValue delegate;
        private final FileTreeInternal fileTree;

        public FileTreeValue(ValidatingValue delegate, FileTreeInternal fileTree) {
            this.delegate = delegate;
            this.fileTree = fileTree;
        }

        @Nullable
        public Object call() {
            return this.fileTree;
        }

        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            this.delegate.validate(propertyName, optional, valueValidator, context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskInputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final boolean skipWhenEmptyOnly;
        private final String taskName;
        private final String type;
        private final List<DeclaredTaskInputFileProperty> filePropertiesInternal;

        public TaskInputUnionFileCollection(String taskName, String type, boolean skipWhenEmptyOnly, List<DeclaredTaskInputFileProperty> filePropertiesInternal) {
            this.taskName = taskName;
            this.type = type;
            this.skipWhenEmptyOnly = skipWhenEmptyOnly;
            this.filePropertiesInternal = filePropertiesInternal;
        }

        @Override
        public String getDisplayName() {
            return "task '" + this.taskName + "' " + this.type + " files";
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
            for (DeclaredTaskInputFileProperty fileProperty : this.filePropertiesInternal) {
                if (this.skipWhenEmptyOnly && !fileProperty.isSkipWhenEmpty()) continue;
                context.add(fileProperty.getPropertyFiles());
            }
        }
    }

    private static class NestedBeanTypePropertyValue
    extends PropertyValue {
        public NestedBeanTypePropertyValue(DeclaredTaskInputProperty propertySpec, ValidatingValue value) {
            super(propertySpec, value);
        }

        public String resolveName() {
            return this.propertySpec.getPropertyName() + ".class";
        }

        public Object resolveValue() {
            Object value = this.value.call();
            return value == null ? null : value.getClass().getName();
        }
    }

    private static class SimplePropertyValue
    extends PropertyValue {
        public SimplePropertyValue(DeclaredTaskInputProperty propertySpec, ValidatingValue value) {
            super(propertySpec, value);
        }

        public String resolveName() {
            return this.propertySpec.getPropertyName();
        }

        public Object resolveValue() {
            return this.value.call();
        }
    }

    private static abstract class PropertyValue {
        protected final DeclaredTaskInputProperty propertySpec;
        protected ValidatingValue value;

        public PropertyValue(DeclaredTaskInputProperty propertySpec, ValidatingValue value) {
            this.propertySpec = propertySpec;
            this.value = value;
        }

        public DeclaredTaskInputProperty getPropertySpec() {
            return this.propertySpec;
        }

        public abstract String resolveName();

        @Nullable
        public abstract Object resolveValue();

        public void setValue(ValidatingValue value) {
            this.value = value;
        }
    }
}

