/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.NativeDependencyCache;
import org.gradle.language.nativeplatform.internal.Names;

public class DefaultCppBinary
implements CppBinary {
    private final String name;
    private final Provider<String> baseName;
    private final boolean debuggable;
    private final FileCollection sourceFiles;
    private final FileCollection includePath;
    private final FileCollection linkLibraries;
    private final FileCollection runtimeLibraries;

    public DefaultCppBinary(String name, ObjectFactory objects, Provider<String> baseName, boolean debuggable, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration implementation) {
        this.name = name;
        this.baseName = baseName;
        this.debuggable = debuggable;
        this.sourceFiles = sourceFiles;
        Names names = Names.of(name);
        Configuration includePathConfig = (Configuration)configurations.maybeCreate(names.withPrefix("cppCompile"));
        includePathConfig.setCanBeConsumed(false);
        includePathConfig.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "cplusplus-api"));
        includePathConfig.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        Configuration nativeLink = (Configuration)configurations.maybeCreate(names.withPrefix("nativeLink"));
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "native-link"));
        nativeLink.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        Configuration nativeRuntime = (Configuration)configurations.maybeCreate(names.withPrefix("nativeRuntime"));
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "native-runtime"));
        nativeRuntime.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        includePathConfig.extendsFrom(new Configuration[]{implementation});
        nativeLink.extendsFrom(new Configuration[]{implementation});
        nativeRuntime.extendsFrom(new Configuration[]{implementation});
        this.includePath = componentHeaderDirs.plus((FileCollection)new FileCollectionAdapter((MinimalFileSet)new IncludePath(includePathConfig, configurations)));
        this.linkLibraries = new FileCollectionAdapter((MinimalFileSet)new LinkLibs(nativeLink, configurations));
        this.runtimeLibraries = new FileCollectionAdapter((MinimalFileSet)new RuntimeLibs(nativeRuntime, configurations));
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TemporaryFileProvider getTemporaryFileProvider() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected NativeDependencyCache getNativeDependencyCache() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Provider<String> getBaseName() {
        return this.baseName;
    }

    @Override
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Override
    public FileCollection getCppSource() {
        return this.sourceFiles;
    }

    @Override
    public FileCollection getCompileIncludePath() {
        return this.includePath;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibraries;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibraries;
    }

    private class RuntimeLibs
    implements MinimalFileSet,
    Buildable {
        private final ConfigurationContainer configurations;
        private final Configuration configuration;
        private Set<File> result;

        RuntimeLibs(Configuration configuration, ConfigurationContainer configurations) {
            this.configuration = configuration;
            this.configurations = configurations;
        }

        public String getDisplayName() {
            return "Runtime libraries for " + DefaultCppBinary.this;
        }

        public TaskDependency getBuildDependencies() {
            return this.configuration.getBuildDependencies();
        }

        public Set<File> getFiles() {
            if (this.result == null) {
                this.configuration.getResolvedConfiguration().rethrowFailure();
                Set components = this.configuration.getIncoming().getResolutionResult().getAllComponents();
                HashSet<ModuleComponentIdentifier> externalComponents = new HashSet<ModuleComponentIdentifier>(components.size());
                ArrayList<DefaultExternalModuleDependency> externalDependencies = new ArrayList<DefaultExternalModuleDependency>(components.size());
                for (ResolvedComponentResult component : components) {
                    if (!(component.getId() instanceof ModuleComponentIdentifier)) continue;
                    ModuleComponentIdentifier id = (ModuleComponentIdentifier)component.getId();
                    externalComponents.add(id);
                    String module = id.getModule() + "_debug";
                    DefaultExternalModuleDependency mappedDependency = new DefaultExternalModuleDependency(id.getGroup(), module, id.getVersion());
                    externalDependencies.add(mappedDependency);
                }
                ArtifactCollection artifacts = this.configuration.getIncoming().getArtifacts();
                LinkedHashSet<File> files = new LinkedHashSet<File>();
                for (ResolvedArtifactResult artifact : artifacts) {
                    if (externalComponents.contains(artifact.getId().getComponentIdentifier())) continue;
                    files.add(artifact.getFile());
                }
                if (!externalDependencies.isEmpty()) {
                    ModuleComponentIdentifier id;
                    Configuration mappedConfiguration = this.configurations.detachedConfiguration(externalDependencies.toArray(new Dependency[0]));
                    mappedConfiguration.getResolutionStrategy().eachDependency((Action)new Action<DependencyResolveDetails>(){

                        public void execute(DependencyResolveDetails details) {
                            ModuleVersionSelector requested = details.getRequested();
                            if (!requested.getName().endsWith("_debug")) {
                                details.useTarget((Object)(requested.getGroup() + ":" + requested.getName() + "_debug:" + requested.getVersion()));
                            }
                        }
                    });
                    mappedConfiguration.getResolvedConfiguration().rethrowFailure();
                    Set runtimeComponents = mappedConfiguration.getIncoming().getResolutionResult().getAllComponents();
                    ArrayList<DefaultExternalModuleDependency> artifactDependencies = new ArrayList<DefaultExternalModuleDependency>();
                    String libExtension = OperatingSystem.current().getSharedLibrarySuffix().substring(1);
                    for (ResolvedComponentResult component : runtimeComponents) {
                        if (!(component.getId() instanceof ModuleComponentIdentifier)) continue;
                        id = (ModuleComponentIdentifier)component.getId();
                        DefaultExternalModuleDependency artifactDependency = new DefaultExternalModuleDependency(id.getGroup(), id.getModule(), id.getVersion());
                        artifactDependency.addArtifact((DependencyArtifact)new DefaultDependencyArtifact(id.getModule(), libExtension, libExtension, null, null));
                        artifactDependencies.add(artifactDependency);
                    }
                    mappedConfiguration = this.configurations.detachedConfiguration(artifactDependencies.toArray(new Dependency[0]));
                    for (ResolvedArtifactResult artifact : mappedConfiguration.getIncoming().getArtifacts().getArtifacts()) {
                        id = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
                        String originalModuleName = id.getModule().substring(0, id.getModule().length() - "_debug".length());
                        String libName = this.getLibraryName(originalModuleName);
                        files.add(DefaultCppBinary.this.getNativeDependencyCache().getBinary(artifact.getFile(), libName));
                    }
                }
                this.result = files;
            }
            return this.result;
        }

        private String getLibraryName(String baseName) {
            return OperatingSystem.current().getSharedLibraryName(baseName);
        }
    }

    private class LinkLibs
    implements MinimalFileSet,
    Buildable {
        private final ConfigurationContainer configurations;
        private final Configuration configuration;
        private Set<File> result;

        LinkLibs(Configuration configuration, ConfigurationContainer configurations) {
            this.configuration = configuration;
            this.configurations = configurations;
        }

        public String getDisplayName() {
            return "Link libraries of " + DefaultCppBinary.this;
        }

        public TaskDependency getBuildDependencies() {
            return this.configuration.getBuildDependencies();
        }

        public Set<File> getFiles() {
            if (this.result == null) {
                this.configuration.getResolvedConfiguration().rethrowFailure();
                Set components = this.configuration.getIncoming().getResolutionResult().getAllComponents();
                HashSet<ModuleComponentIdentifier> externalComponents = new HashSet<ModuleComponentIdentifier>(components.size());
                ArrayList<DefaultExternalModuleDependency> externalDependencies = new ArrayList<DefaultExternalModuleDependency>(components.size());
                String libExtension = OperatingSystem.current().getLinkLibrarySuffix().substring(1);
                for (ResolvedComponentResult component : components) {
                    if (!(component.getId() instanceof ModuleComponentIdentifier)) continue;
                    ModuleComponentIdentifier id = (ModuleComponentIdentifier)component.getId();
                    externalComponents.add(id);
                    String module = id.getModule() + "_debug";
                    DefaultExternalModuleDependency mappedDependency = new DefaultExternalModuleDependency(id.getGroup(), module, id.getVersion());
                    mappedDependency.addArtifact((DependencyArtifact)new DefaultDependencyArtifact(module, libExtension, libExtension, null, null));
                    externalDependencies.add(mappedDependency);
                }
                ArtifactCollection artifacts = this.configuration.getIncoming().getArtifacts();
                LinkedHashSet<File> files = new LinkedHashSet<File>();
                for (ResolvedArtifactResult artifact : artifacts) {
                    if (externalComponents.contains(artifact.getId().getComponentIdentifier())) continue;
                    files.add(artifact.getFile());
                }
                if (!externalDependencies.isEmpty()) {
                    Configuration mappedConfiguration = this.configurations.detachedConfiguration(externalDependencies.toArray(new Dependency[0]));
                    for (ResolvedArtifactResult artifact : mappedConfiguration.getIncoming().getArtifacts().getArtifacts()) {
                        ModuleComponentIdentifier id = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
                        String originalModuleName = id.getModule().substring(0, id.getModule().length() - "_debug".length());
                        String libName = this.getLibraryName(originalModuleName);
                        files.add(DefaultCppBinary.this.getNativeDependencyCache().getBinary(artifact.getFile(), libName));
                    }
                }
                this.result = files;
            }
            return this.result;
        }

        private String getLibraryName(String baseName) {
            return OperatingSystem.current().getLinkLibraryName(baseName);
        }
    }

    private class IncludePath
    implements MinimalFileSet {
        private final Configuration includePathConfig;
        private final ConfigurationContainer configurationContainer;
        private Set<File> result;

        IncludePath(Configuration includePathConfig, ConfigurationContainer configurationContainer) {
            this.includePathConfig = includePathConfig;
            this.configurationContainer = configurationContainer;
        }

        public String getDisplayName() {
            return "Include path for " + DefaultCppBinary.this.toString();
        }

        public Set<File> getFiles() {
            if (this.result == null) {
                this.includePathConfig.getResolvedConfiguration().rethrowFailure();
                Set components = this.includePathConfig.getIncoming().getResolutionResult().getAllComponents();
                HashSet<ModuleComponentIdentifier> externalComponents = new HashSet<ModuleComponentIdentifier>(components.size());
                ArrayList<DefaultExternalModuleDependency> externalDependencies = new ArrayList<DefaultExternalModuleDependency>(components.size());
                for (ResolvedComponentResult component : components) {
                    if (!(component.getId() instanceof ModuleComponentIdentifier)) continue;
                    ModuleComponentIdentifier id = (ModuleComponentIdentifier)component.getId();
                    externalComponents.add(id);
                    DefaultExternalModuleDependency mappedDependency = new DefaultExternalModuleDependency(id.getGroup(), id.getModule(), id.getVersion());
                    mappedDependency.addArtifact((DependencyArtifact)new DefaultDependencyArtifact(id.getModule(), "zip", "zip", "cpp-api-headers", null));
                    externalDependencies.add(mappedDependency);
                }
                ArtifactCollection artifacts = this.includePathConfig.getIncoming().getArtifacts();
                LinkedHashSet<File> files = new LinkedHashSet<File>();
                for (ResolvedArtifactResult artifact : artifacts) {
                    if (externalComponents.contains(artifact.getId().getComponentIdentifier())) continue;
                    files.add(artifact.getFile());
                }
                if (!externalDependencies.isEmpty()) {
                    NativeDependencyCache cache = DefaultCppBinary.this.getNativeDependencyCache();
                    Configuration mappedConfiguration = this.configurationContainer.detachedConfiguration(externalDependencies.toArray(new Dependency[0]));
                    for (ResolvedArtifactResult artifact : mappedConfiguration.getIncoming().getArtifacts()) {
                        ModuleComponentIdentifier id = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
                        File headerDir = cache.getUnpackedHeaders(artifact.getFile(), id.getModule() + "-" + id.getVersion());
                        files.add(headerDir);
                    }
                }
                this.result = files;
            }
            return this.result;
        }
    }
}

