/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.changes.DiscoveredInputRecorder;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.nativeplatform.internal.incremental.DefaultHeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.HeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilerBuilder;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public abstract class AbstractNativeCompileTask
extends DefaultTask {
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private boolean positionIndependentCode;
    private boolean debug;
    private boolean optimize;
    private final DirectoryProperty objectFileDir;
    private final ConfigurableFileCollection includes;
    private final ConfigurableFileCollection source;
    private final Map<String, String> macros = new LinkedHashMap<String, String>();
    private final ListProperty<String> compilerArgs;
    private ImmutableList<String> includePaths;
    private final RegularFileProperty headerDependenciesFile;

    public AbstractNativeCompileTask() {
        this.includes = this.getProject().files(new Object[0]);
        this.source = this.getProject().files(new Object[0]);
        this.objectFileDir = this.newOutputDirectory();
        this.compilerArgs = this.getProject().getObjects().listProperty(String.class);
        this.headerDependenciesFile = this.newInputFile();
        this.getInputs().property("outputType", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return NativeToolChainInternal.Identifier.identify((NativeToolChainInternal)AbstractNativeCompileTask.this.toolChain, (NativePlatformInternal)AbstractNativeCompileTask.this.targetPlatform);
            }
        });
        this.getOutputs().doNotCacheIf("Experimental native caching is not enabled", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return !Boolean.getBoolean("org.gradle.caching.native");
            }
        });
        this.getOutputs().doNotCacheIf("No header dependency analysis provided", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return !AbstractNativeCompileTask.this.getHeaderDependenciesFile().isPresent();
            }
        });
        this.dependsOn(new Object[]{this.includes});
    }

    @Inject
    protected IncrementalCompilerBuilder getIncrementalCompilerBuilder() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void compile(IncrementalTaskInputs inputs) {
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        NativeCompileSpec spec = this.createCompileSpec();
        spec.setTargetPlatform((NativePlatform)this.targetPlatform);
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(((Directory)this.objectFileDir.get()).getAsFile());
        spec.include((Iterable)this.includes);
        spec.source((Iterable)this.getSource());
        spec.setMacros(this.getMacros());
        spec.args((List)this.getCompilerArgs().get());
        spec.setPositionIndependentCode(this.isPositionIndependentCode());
        spec.setDebuggable(this.isDebuggable());
        spec.setOptimized(this.isOptimized());
        spec.setIncrementalCompile(inputs.isIncremental());
        spec.setDiscoveredInputRecorder((DiscoveredInputRecorder)inputs);
        spec.setOperationLogger(operationLogger);
        this.configureSpec(spec);
        PlatformToolProvider platformToolProvider = this.toolChain.select(this.targetPlatform);
        this.setDidWork(this.doCompile(spec, platformToolProvider).getDidWork());
    }

    protected void configureSpec(NativeCompileSpec spec) {
    }

    private <T extends NativeCompileSpec> WorkResult doCompile(T spec, PlatformToolProvider platformToolProvider) {
        Class specType = (Class)Cast.uncheckedCast(spec.getClass());
        Compiler baseCompiler = platformToolProvider.newCompiler(specType);
        HeaderDependenciesCollector headerDependenciesCollector = this.getHeaderDependenciesFile().isPresent() ? HeaderDependenciesCollector.NOOP : this.createDependenciesCollector();
        Compiler incrementalCompiler = this.getIncrementalCompilerBuilder().createIncrementalCompiler((TaskInternal)this, baseCompiler, (NativeToolChain)this.toolChain, headerDependenciesCollector);
        Compiler loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap(incrementalCompiler);
        return loggingCompiler.execute(spec);
    }

    private DefaultHeaderDependenciesCollector createDependenciesCollector() {
        return new DefaultHeaderDependenciesCollector((DirectoryFileTreeFactory)((ProjectInternal)this.getProject()).getServices().get(DirectoryFileTreeFactory.class));
    }

    protected abstract NativeCompileSpec createCompileSpec();

    @Internal
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    @Nested
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @Input
    public boolean isPositionIndependentCode() {
        return this.positionIndependentCode;
    }

    public void setPositionIndependentCode(boolean positionIndependentCode) {
        this.positionIndependentCode = positionIndependentCode;
    }

    @Input
    public boolean isDebuggable() {
        return this.debug;
    }

    public void setDebuggable(boolean debug) {
        this.debug = debug;
    }

    @Input
    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimized(boolean optimize) {
        this.optimize = optimize;
    }

    @OutputDirectory
    public DirectoryProperty getObjectFileDir() {
        return this.objectFileDir;
    }

    @Internal(value="The paths for include directories are tracked via the includePaths property, the contents are tracked via discovered inputs")
    public ConfigurableFileCollection getIncludes() {
        return this.includes;
    }

    @Input
    @Optional
    protected Collection<String> getIncludePaths() {
        if (this.headerDependenciesFile.isPresent()) {
            return null;
        }
        if (this.includePaths == null) {
            Set roots = this.includes.getFiles();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (File root : roots) {
                builder.add((Object)root.getAbsolutePath());
            }
            this.includePaths = builder.build();
        }
        return this.includePaths;
    }

    public void includes(Object includeRoots) {
        this.includes.from(new Object[]{includeRoots});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(new Object[]{sourceFiles});
    }

    @Input
    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros.clear();
        this.macros.putAll(macros);
    }

    @Input
    public ListProperty<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @Internal
    public RegularFileProperty getHeaderDependenciesFile() {
        return this.headerDependenciesFile;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    protected FileCollection getHeaderDependencies() throws IOException {
        File inputFile = (File)this.headerDependenciesFile.getAsFile().getOrNull();
        if (inputFile == null || !inputFile.isFile()) {
            return null;
        }
        List lines = Files.readLines((File)inputFile, (Charset)Charsets.UTF_8);
        HashSet<File> files = new HashSet<File>();
        for (String line : lines) {
            files.add(new File(line));
        }
        return new SimpleFileCollection(files);
    }
}

