/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public class VFileCopyEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myNewParent;
    private final String myNewChildName;

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getFile"));
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile2 = this.myNewParent;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getNewParent"));
        }
        return virtualFile2;
    }

    @NotNull
    public String getNewChildName() {
        String string = this.myNewChildName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getNewChildName"));
        }
        return string;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[copy " + this.myFile + " to " + this.myNewParent + " as " + this.myNewChildName + "]";
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCopyEvent event = (VFileCopyEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewChildName.equals(event.myNewChildName)) {
            return false;
        }
        return this.myNewParent.equals(event.myNewParent);
    }

    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myNewParent.hashCode();
        result2 = 31 * result2 + this.myNewChildName.hashCode();
        return result2;
    }
}

