/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.util.PathUtilRt;

public class PathUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.PathUtil");

    private PathUtil() {
    }

    @NotNull
    public static String getLocalPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/util/PathUtil", "getLocalPath"));
        }
        String string = FileUtil.toSystemDependentName(StringUtil.trimEnd(path, "!/"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/PathUtil", "getLocalPath"));
        }
        return string;
    }

    @NotNull
    public static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        String string = PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        return string;
    }

    @NotNull
    public static String getFileName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/util/PathUtil", "getFileName"));
        }
        String string = PathUtilRt.getFileName(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/PathUtil", "getFileName"));
        }
        return string;
    }
}

