/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.DefaultIvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class IvyArtifactNotationParserFactory
implements Factory<NotationParser<Object, IvyArtifact>> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final IvyPublicationIdentity publicationIdentity;

    public IvyArtifactNotationParserFactory(Instantiator instantiator, FileResolver fileResolver, IvyPublicationIdentity publicationIdentity) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
        this.publicationIdentity = publicationIdentity;
    }

    public NotationParser<Object, IvyArtifact> create() {
        FileNotationConverter fileNotationConverter = new FileNotationConverter(this.fileResolver);
        ArchiveTaskNotationConverter archiveTaskNotationConverter = new ArchiveTaskNotationConverter();
        PublishArtifactNotationConverter publishArtifactNotationConverter = new PublishArtifactNotationConverter();
        NotationParser sourceNotationParser = NotationParserBuilder.toType(IvyArtifact.class).converter((NotationConverter)archiveTaskNotationConverter).converter((NotationConverter)publishArtifactNotationConverter).converter((NotationConverter)fileNotationConverter).toComposite();
        IvyArtifactMapNotationConverter ivyArtifactMapNotationConverter = new IvyArtifactMapNotationConverter(sourceNotationParser);
        NotationParserBuilder parserBuilder = NotationParserBuilder.toType(IvyArtifact.class).converter((NotationConverter)archiveTaskNotationConverter).converter((NotationConverter)publishArtifactNotationConverter).converter((NotationConverter)ivyArtifactMapNotationConverter).converter((NotationConverter)fileNotationConverter);
        return parserBuilder.toComposite();
    }

    private DefaultIvyArtifact createDefaultIvyArtifact(File file, String extension, String type, String classifier) {
        DefaultIvyArtifact ivyArtifact = (DefaultIvyArtifact)this.instantiator.newInstance(DefaultIvyArtifact.class, new Object[]{file, null, extension, type, classifier});
        new DslObject((Object)ivyArtifact).getConventionMapping().map("name", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return IvyArtifactNotationParserFactory.this.publicationIdentity.getModule();
            }
        });
        return ivyArtifact;
    }

    private class IvyArtifactMapNotationConverter
    extends MapNotationConverter<IvyArtifact> {
        private final NotationParser<Object, IvyArtifact> sourceNotationParser;

        private IvyArtifactMapNotationConverter(NotationParser<Object, IvyArtifact> sourceNotationParser) {
            this.sourceNotationParser = sourceNotationParser;
        }

        protected IvyArtifact parseMap(@MapKey(value="source") Object source) {
            return (IvyArtifact)this.sourceNotationParser.parseNotation(source);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps containing a 'source' entry").example("[source: '/path/to/file', extension: 'zip']");
        }
    }

    private class FileNotationConverter
    implements NotationConverter<Object, IvyArtifact> {
        private final NotationParser<Object, File> fileResolverNotationParser;

        private FileNotationConverter(FileResolver fileResolver) {
            this.fileResolverNotationParser = fileResolver.asNotationParser();
        }

        public void convert(Object notation, NotationConvertResult<? super IvyArtifact> result) throws TypeConversionException {
            File file = (File)this.fileResolverNotationParser.parseNotation(notation);
            result.converted((Object)this.parseFile(file));
        }

        protected IvyArtifact parseFile(File file) {
            String extension = StringUtils.substringAfterLast((String)file.getName(), (String)".");
            return IvyArtifactNotationParserFactory.this.createDefaultIvyArtifact(file, extension, extension, null);
        }

        public void describe(DiagnosticsVisitor visitor) {
            this.fileResolverNotationParser.describe(visitor);
        }
    }

    private class PublishArtifactNotationConverter
    extends TypedNotationConverter<PublishArtifact, IvyArtifact> {
        private PublishArtifactNotationConverter() {
            super(PublishArtifact.class);
        }

        protected IvyArtifact parseType(PublishArtifact publishArtifact) {
            DefaultIvyArtifact ivyArtifact = IvyArtifactNotationParserFactory.this.createDefaultIvyArtifact(publishArtifact.getFile(), publishArtifact.getExtension(), publishArtifact.getType(), publishArtifact.getClassifier());
            ivyArtifact.builtBy(publishArtifact.getBuildDependencies());
            return ivyArtifact;
        }
    }

    private class ArchiveTaskNotationConverter
    extends TypedNotationConverter<AbstractArchiveTask, IvyArtifact> {
        private ArchiveTaskNotationConverter() {
            super(AbstractArchiveTask.class);
        }

        protected IvyArtifact parseType(AbstractArchiveTask archiveTask) {
            DefaultIvyArtifact ivyArtifact = IvyArtifactNotationParserFactory.this.createDefaultIvyArtifact(archiveTask.getArchivePath(), archiveTask.getExtension(), archiveTask.getExtension(), archiveTask.getClassifier());
            ivyArtifact.builtBy(archiveTask);
            return ivyArtifact;
        }
    }
}

