/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BitEncoding;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmProtoBufUtil {
    @NotNull
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;
    public static final JvmProtoBufUtil INSTANCE;

    @NotNull
    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        byte[] byArray = BitEncoding.decodeBytes(data2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readClassDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return new Pair((Object)INSTANCE.readNameResolver(input, strings), (Object)ProtoBuf.Class.parseFrom(input, EXTENSION_REGISTRY));
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        byte[] byArray = BitEncoding.decodeBytes(data2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return new Pair((Object)INSTANCE.readNameResolver(input, strings), (Object)ProtoBuf.Package.parseFrom(input, EXTENSION_REGISTRY));
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Function> readFunctionDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        ByteArrayInputStream input = new ByteArrayInputStream(BitEncoding.decodeBytes(data2));
        return new Pair((Object)INSTANCE.readNameResolver(input, strings), (Object)ProtoBuf.Function.parseFrom(input, EXTENSION_REGISTRY));
    }

    private final JvmNameResolver readNameResolver(@NotNull InputStream $receiver, String[] strings) {
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom($receiver, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringTableTypes, (String)"JvmProtoBuf.StringTableT\u2026this, EXTENSION_REGISTRY)");
        return new JvmNameResolver(stringTableTypes, strings);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmMethodSignature(@NotNull ProtoBuf.Function proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.methodSignature;
        Intrinsics.checkExpressionValueIsNotNull(generatedExtension, (String)"JvmProtoBuf.methodSignature");
        JvmProtoBuf.JvmMethodSignature signature2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        int n = name = signature2 != null && signature2.hasName() ? signature2.getName() : proto.getName();
        if (signature2 != null && signature2.hasDesc()) {
            string = nameResolver.getString(signature2.getDesc());
        } else {
            void $receiver$iv$iv;
            Object object;
            void $receiver$iv$iv2;
            void $receiver$iv;
            Collection collection = CollectionsKt.listOfNotNull((Object)ProtoTypeTableUtilKt.receiverType(proto, typeTable));
            List<ProtoBuf.ValueParameter> list = proto.getValueParameterList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"proto.valueParameterList");
            Iterable iterable = list;
            Collection collection2 = collection;
            void var9_8 = $receiver$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                object = destination$iv$iv;
                void v6 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)v6, typeTable);
                object.add(type2);
            }
            object = (List)destination$iv$iv;
            List parameterTypes = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)object));
            Iterable $receiver$iv2 = parameterTypes;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ProtoBuf.Type $i$a$1$map = (ProtoBuf.Type)item$iv$iv;
                collection2 = destination$iv$iv2;
                if (INSTANCE.mapTypeDefault((ProtoBuf.Type)it, nameResolver) == null) {
                    return null;
                }
                collection2.add(object);
            }
            List parametersDesc = (List)destination$iv$iv2;
            String string2 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string2 == null) {
                return null;
            }
            String returnTypeDesc = string2;
            string = CollectionsKt.joinToString$default((Iterable)parametersDesc, (CharSequence)"", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null) + returnTypeDesc;
        }
        String desc = string;
        return nameResolver.getString(name) + desc;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmConstructorSignature(@NotNull ProtoBuf.Constructor proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Constructor, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.constructorSignature;
        Intrinsics.checkExpressionValueIsNotNull(generatedExtension, (String)"JvmProtoBuf.constructorSignature");
        JvmProtoBuf.JvmMethodSignature signature2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (signature2 != null && signature2.hasDesc()) {
            string = nameResolver.getString(signature2.getDesc());
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            List<ProtoBuf.ValueParameter> list = proto.getValueParameterList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"proto.valueParameterList");
            Iterable iterable = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string2;
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                if (INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)v4, typeTable), nameResolver) == null) {
                    return null;
                }
                collection.add(string2);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", (CharSequence)"(", (CharSequence)")V", (int)0, null, null, (int)56, null);
        }
        String desc = string;
        return "<init>" + desc;
    }

    @Nullable
    public final PropertySignature getJvmFieldSignature(@NotNull ProtoBuf.Property proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
        Intrinsics.checkExpressionValueIsNotNull(generatedExtension, (String)"JvmProtoBuf.propertySignature");
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (jvmPropertySignature == null) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature2 = jvmPropertySignature;
        JvmProtoBuf.JvmFieldSignature field = signature2.hasField() ? signature2.getField() : null;
        int n = name = field != null && field.hasName() ? field.getName() : proto.getName();
        if (field != null && field.hasDesc()) {
            string = nameResolver.getString(field.getDesc());
        } else {
            string = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string == null) {
                return null;
            }
        }
        String desc = string;
        return new PropertySignature(nameResolver.getString(name), desc);
    }

    private final String mapTypeDefault(ProtoBuf.Type type2, NameResolver nameResolver) {
        return type2.hasClassName() ? ClassMapperLite.mapClass(nameResolver.getQualifiedClassName(type2.getClassName())) : null;
    }

    private JvmProtoBufUtil() {
    }

    static {
        ExtensionRegistryLite extensionRegistryLite;
        JvmProtoBufUtil jvmProtoBufUtil;
        INSTANCE = jvmProtoBufUtil = new JvmProtoBufUtil();
        ExtensionRegistryLite p1 = extensionRegistryLite = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(p1);
        ExtensionRegistryLite extensionRegistryLite2 = extensionRegistryLite;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionRegistryLite2, (String)"ExtensionRegistryLite.ne\u2026f::registerAllExtensions)");
        EXTENSION_REGISTRY = extensionRegistryLite2;
    }

    public static final class PropertySignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public PropertySignature(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            this.name = name;
            this.desc = desc;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.desc;
        }

        public String toString() {
            return "PropertySignature(name=" + this.name + ", desc=" + this.desc + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.desc;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertySignature)) break block3;
                    PropertySignature propertySignature = (PropertySignature)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)propertySignature.name) || !Intrinsics.areEqual((Object)this.desc, (Object)propertySignature.desc)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

