/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.changedetection.state.OutputPathNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.PathNormalizationStrategy;
import org.gradle.api.internal.tasks.GenericFileNormalizer;
import org.gradle.api.internal.tasks.TaskOutputsDeprecationSupport;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
abstract class AbstractTaskOutputPropertySpec
extends TaskOutputsDeprecationSupport
implements TaskPropertySpec,
TaskOutputFilePropertyBuilder {
    private String propertyName;
    private boolean optional;

    AbstractTaskOutputPropertySpec() {
    }

    public TaskOutputFilePropertyBuilder withPropertyName(String propertyName) {
        this.propertyName = TaskPropertyUtils.checkPropertyName(propertyName);
        return this;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    protected boolean isOptional() {
        return this.optional;
    }

    public TaskOutputFilePropertyBuilder optional() {
        return this.optional(true);
    }

    public TaskOutputFilePropertyBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public PathNormalizationStrategy getPathNormalizationStrategy() {
        return OutputPathNormalizationStrategy.getInstance();
    }

    public String toString() {
        return this.getPropertyName() + " (OUTPUT)";
    }

    public Class<? extends FileNormalizer> getNormalizer() {
        return GenericFileNormalizer.class;
    }

    @Override
    public int compareTo(TaskPropertySpec o) {
        return this.getPropertyName().compareTo(o.getPropertyName());
    }
}

