/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.internal.Factory;
import org.gradle.internal.featurelifecycle.FeatureHandler;
import org.gradle.internal.featurelifecycle.FeatureUsage;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.LoggingIncubatingFeatureHandler;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SingleMessageLogger {
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    public static final String INCUBATION_MESSAGE = "%s is an incubating feature.";
    private static LoggingDeprecatedFeatureHandler deprecatedFeatureHandler = new LoggingDeprecatedFeatureHandler();
    private static LoggingIncubatingFeatureHandler incubatingFeatureHandler = new LoggingIncubatingFeatureHandler();

    public static synchronized void reset() {
        deprecatedFeatureHandler.reset();
        incubatingFeatureHandler.reset();
    }

    public static synchronized void init(UsageLocationReporter reporter, WarningMode warningMode) {
        deprecatedFeatureHandler.init(reporter, warningMode);
    }

    public static synchronized void reportSuppressedDeprecations() {
        deprecatedFeatureHandler.reportSuppressedDeprecations();
    }

    public static void nagUserOfReplacedPlugin(String pluginName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s plugin %s. Please use the %s plugin instead.", pluginName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfPluginReplacedWithExternalOne(String pluginName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s plugin %s. Consider using the %s plugin instead.", pluginName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfToolReplacedWithExternalOne(String toolName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s %s. Consider using %s instead.", toolName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfReplacedTask(String taskName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s task %s. Please use the %s task instead.", taskName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfReplacedTaskType(String taskName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s task type %s. Please use the %s instead.", taskName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfReplacedMethod(String methodName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method %s. Please use the %s method instead.", methodName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfReplacedProperty(String propertyName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s property %s. Please use the %s property instead.", propertyName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method %s.", methodName, LoggingDeprecatedFeatureHandler.getDeprecationMessage()));
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method %s. %s", methodName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), advice));
        }
    }

    public static void nagUserOfDiscontinuedProperty(String propertyName, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s property %s. %s", propertyName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), advice));
        }
    }

    public static void nagUserOfDiscontinuedApi(String api, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s %s. %s", api, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), advice));
        }
    }

    public static void nagUserOfReplacedNamedParameter(String parameterName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s named parameter %s. Please use the %s named parameter instead.", parameterName, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserWith(String message) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(deprecatedFeatureHandler, new FeatureUsage(message, SingleMessageLogger.class));
        }
    }

    private static synchronized void nagUserWith(FeatureHandler handler, FeatureUsage usage) {
        handler.featureUsed(usage);
    }

    public static void nagUserOfDeprecated(String thing) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s %s", thing, LoggingDeprecatedFeatureHandler.getDeprecationMessage()));
        }
    }

    public static void nagUserOfDeprecated(String thing, String explanation) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s %s. %s.", thing, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), explanation));
        }
    }

    public static void nagUserOfDeprecatedBehaviour(String behaviour) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserOfDeprecated(String.format("%s. This behaviour", behaviour));
        }
    }

    public static void nagUserOfDeprecatedThing(String thing, String explanation) {
        if (SingleMessageLogger.isEnabled()) {
            if (StringUtils.isEmpty((String)explanation)) {
                SingleMessageLogger.nagUserWith(String.format("%s. This %s.", thing, LoggingDeprecatedFeatureHandler.getDeprecationMessage()));
            } else {
                SingleMessageLogger.nagUserWith(String.format("%s. This %s. %s.", thing, LoggingDeprecatedFeatureHandler.getDeprecationMessage(), explanation));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T whileDisabled(Factory<T> factory) {
        ENABLED.set(false);
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            ENABLED.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whileDisabled(Runnable action) {
        ENABLED.set(false);
        try {
            action.run();
        }
        finally {
            ENABLED.set(true);
        }
    }

    private static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void incubatingFeatureUsed(String incubatingFeature) {
        SingleMessageLogger.nagUserWith(incubatingFeatureHandler, new FeatureUsage(incubatingFeature, SingleMessageLogger.class));
    }
}

