/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;

class CompositeConflictResolver
implements ModuleConflictResolver {
    private final List<ModuleConflictResolver> resolvers = new LinkedList<ModuleConflictResolver>();

    CompositeConflictResolver() {
    }

    @Override
    public <T extends ComponentResolutionState> void select(ConflictResolverDetails<T> details) {
        CompositeDetails composite = new CompositeDetails(details);
        for (ModuleConflictResolver r : this.resolvers) {
            r.select(composite);
            if (!composite.hasResult) continue;
            return;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " was unable to select a candidate using resolvers: " + this.resolvers + ". Candidates: " + details.getCandidates());
    }

    void addFirst(ModuleConflictResolver conflictResolver) {
        this.resolvers.add(0, conflictResolver);
    }

    private static class CompositeDetails<T extends ComponentResolutionState>
    implements ConflictResolverDetails<T> {
        private final ConflictResolverDetails<T> delegate;
        private boolean hasResult;

        private CompositeDetails(ConflictResolverDetails<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Collection<? extends T> getCandidates() {
            return this.delegate.getCandidates();
        }

        @Override
        public void select(T candidate) {
            this.hasResult = true;
            this.delegate.select(candidate);
        }

        @Override
        public void fail(Throwable error) {
            this.hasResult = true;
            this.delegate.fail(error);
        }

        @Override
        public T getSelected() {
            return this.delegate.getSelected();
        }

        @Override
        public boolean isRestart() {
            return this.delegate.isRestart();
        }

        @Override
        @Nullable
        public Throwable getFailure() {
            return this.delegate.getFailure();
        }

        @Override
        public boolean hasFailure() {
            return this.delegate.hasFailure();
        }

        @Override
        public boolean hasSelected() {
            return this.delegate.hasSelected();
        }
    }
}

