/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.services;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BasicProjectGenerator;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.CompositeProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.DefaultTemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.GitIgnoreGenerator;
import org.gradle.buildinit.plugins.internal.GroovyApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.GroovyLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.JavaApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.JavaLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.KotlinApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.KotlinLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.ProjectLayoutSetupRegistry;
import org.gradle.buildinit.plugins.internal.ResourceDirsGenerator;
import org.gradle.buildinit.plugins.internal.ScalaLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.SimpleGlobalFilesBuildSettingsDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.maven.PomProjectInitDescriptor;
import org.gradle.internal.file.PathToFileResolver;

public class ProjectLayoutSetupRegistryFactory {
    private final DocumentationRegistry documentationRegistry;
    private final MavenSettingsProvider mavenSettingsProvider;
    private final FileResolver fileResolver;

    public ProjectLayoutSetupRegistryFactory(MavenSettingsProvider mavenSettingsProvider, DocumentationRegistry documentationRegistry, FileResolver fileResolver) {
        this.mavenSettingsProvider = mavenSettingsProvider;
        this.documentationRegistry = documentationRegistry;
        this.fileResolver = fileResolver;
    }

    public ProjectLayoutSetupRegistry createProjectLayoutSetupRegistry() {
        DefaultTemplateLibraryVersionProvider libraryVersionProvider = new DefaultTemplateLibraryVersionProvider();
        TemplateOperationFactory templateOperationBuilder = new TemplateOperationFactory("/org/gradle/buildinit/tasks/templates", (PathToFileResolver)this.fileResolver, this.documentationRegistry);
        BuildScriptBuilderFactory scriptBuilderFactory = new BuildScriptBuilderFactory((PathToFileResolver)this.fileResolver);
        SimpleGlobalFilesBuildSettingsDescriptor settingsDescriptor = new SimpleGlobalFilesBuildSettingsDescriptor(scriptBuilderFactory, this.documentationRegistry);
        ResourceDirsGenerator resourcesGenerator = new ResourceDirsGenerator((PathToFileResolver)this.fileResolver);
        GitIgnoreGenerator gitIgnoreGenerator = new GitIgnoreGenerator(this.fileResolver);
        ImmutableList jvmProjectGenerators = ImmutableList.of((Object)settingsDescriptor, (Object)gitIgnoreGenerator, (Object)resourcesGenerator);
        ImmutableList commonGenerators = ImmutableList.of((Object)settingsDescriptor, (Object)gitIgnoreGenerator);
        BuildInitializer basicType = this.of(new BasicProjectGenerator(scriptBuilderFactory), (List<BuildContentGenerator>)commonGenerators);
        PomProjectInitDescriptor mavenBuildConverter = new PomProjectInitDescriptor((PathToFileResolver)this.fileResolver, this.mavenSettingsProvider, scriptBuilderFactory);
        ProjectLayoutSetupRegistry registry = new ProjectLayoutSetupRegistry(basicType, mavenBuildConverter);
        registry.add(this.of(new JavaLibraryProjectInitDescriptor(scriptBuilderFactory, templateOperationBuilder, this.fileResolver, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new JavaApplicationProjectInitDescriptor(scriptBuilderFactory, templateOperationBuilder, this.fileResolver, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new GroovyApplicationProjectInitDescriptor(scriptBuilderFactory, templateOperationBuilder, this.fileResolver, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new GroovyLibraryProjectInitDescriptor(scriptBuilderFactory, templateOperationBuilder, this.fileResolver, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new ScalaLibraryProjectInitDescriptor(scriptBuilderFactory, templateOperationBuilder, this.fileResolver, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new KotlinApplicationProjectInitDescriptor(scriptBuilderFactory, templateOperationBuilder, this.fileResolver, libraryVersionProvider), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new KotlinLibraryProjectInitDescriptor(scriptBuilderFactory, templateOperationBuilder, this.fileResolver, libraryVersionProvider), (List<BuildContentGenerator>)jvmProjectGenerators));
        return registry;
    }

    private BuildInitializer of(ProjectGenerator projectGenerator, List<BuildContentGenerator> generators) {
        return new CompositeProjectInitDescriptor(projectGenerator, generators);
    }
}

