/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformArtifactOperation
implements RunnableBuildOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformArtifactOperation.class);
    private final ComponentArtifactIdentifier artifactId;
    private final File file;
    private final ArtifactTransformer transform;
    private final ArtifactTransformListener transformListener;
    private Throwable failure;
    private List<File> result;

    TransformArtifactOperation(ComponentArtifactIdentifier artifactId, File file, ArtifactTransformer transform, ArtifactTransformListener transformListener) {
        this.artifactId = artifactId;
        this.file = file;
        this.transform = transform;
        this.transformListener = transformListener;
    }

    public void run(@Nullable BuildOperationContext context) {
        boolean hasCachedResult = this.transform.hasCachedResult(this.file);
        if (!hasCachedResult) {
            this.transformListener.beforeTransform(this.transform, this.artifactId, this.file);
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Executing transform {} on artifact {}", (Object)this.transform.getDisplayName(), (Object)this.artifactId.getDisplayName());
            }
            this.result = this.transform.transform(this.file);
        }
        catch (Exception t) {
            this.failure = t;
        }
        if (!hasCachedResult) {
            this.transformListener.afterTransform(this.transform, this.artifactId, this.file, this.failure);
        }
    }

    public BuildOperationDescriptor.Builder description() {
        String displayName = "Transform " + this.artifactId.getDisplayName() + " with " + this.transform.getDisplayName();
        return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).operationType(BuildOperationCategory.UNCATEGORIZED);
    }

    @Nullable
    public Throwable getFailure() {
        return this.failure;
    }

    @Nullable
    public List<File> getResult() {
        return this.result;
    }
}

