/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class TaskExecutionFingerprintSerializer
extends AbstractSerializer<HistoricalTaskExecution> {
    private final InputPropertiesSerializer inputPropertiesSerializer;
    private final Serializer<HistoricalFileCollectionFingerprint> fileCollectionFingerprintSerializer;
    private final Serializer<ImplementationSnapshot> implementationSnapshotSerializer;

    public TaskExecutionFingerprintSerializer(Serializer<HistoricalFileCollectionFingerprint> fileCollectionFingerprintSerializer) {
        this.fileCollectionFingerprintSerializer = fileCollectionFingerprintSerializer;
        this.inputPropertiesSerializer = new InputPropertiesSerializer();
        this.implementationSnapshotSerializer = new ImplementationSnapshot.SerializerImpl();
    }

    public HistoricalTaskExecution read(Decoder decoder) throws Exception {
        boolean successful = decoder.readBoolean();
        OriginTaskExecutionMetadata originExecutionMetadata = new OriginTaskExecutionMetadata(UniqueId.from((String)decoder.readString()), decoder.readLong());
        ImmutableSortedMap<String, HistoricalFileCollectionFingerprint> inputFilesFingerprints = this.readFingerprints(decoder);
        ImmutableSortedMap<String, HistoricalFileCollectionFingerprint> outputFilesFingerprints = this.readFingerprints(decoder);
        ImplementationSnapshot taskImplementation = (ImplementationSnapshot)this.implementationSnapshotSerializer.read(decoder);
        int taskActionsCount = decoder.readSmallInt();
        ImmutableList.Builder taskActionImplementationsBuilder = ImmutableList.builder();
        for (int j = 0; j < taskActionsCount; ++j) {
            ImplementationSnapshot actionImpl = (ImplementationSnapshot)this.implementationSnapshotSerializer.read(decoder);
            taskActionImplementationsBuilder.add((Object)actionImpl);
        }
        ImmutableList taskActionImplementations = taskActionImplementationsBuilder.build();
        int cacheableOutputPropertiesCount = decoder.readSmallInt();
        ImmutableSortedSet.Builder cacheableOutputPropertiesBuilder = ImmutableSortedSet.naturalOrder();
        for (int j = 0; j < cacheableOutputPropertiesCount; ++j) {
            cacheableOutputPropertiesBuilder.add((Object)decoder.readString());
        }
        ImmutableSortedSet cacheableOutputProperties = cacheableOutputPropertiesBuilder.build();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = this.inputPropertiesSerializer.read(decoder);
        return new HistoricalTaskExecution(taskImplementation, (ImmutableList<ImplementationSnapshot>)taskActionImplementations, inputProperties, (ImmutableSortedSet<String>)cacheableOutputProperties, inputFilesFingerprints, outputFilesFingerprints, successful, originExecutionMetadata);
    }

    public void write(Encoder encoder, HistoricalTaskExecution execution) throws Exception {
        encoder.writeBoolean(execution.isSuccessful());
        encoder.writeString((CharSequence)execution.getOriginExecutionMetadata().getBuildInvocationId().asString());
        encoder.writeLong(execution.getOriginExecutionMetadata().getExecutionTime());
        this.writeFingerprints(encoder, (Map<String, HistoricalFileCollectionFingerprint>)execution.getInputFingerprints());
        this.writeFingerprints(encoder, (Map<String, HistoricalFileCollectionFingerprint>)execution.getOutputFingerprints());
        this.implementationSnapshotSerializer.write(encoder, (Object)execution.getTaskImplementation());
        encoder.writeSmallInt(execution.getTaskActionImplementations().size());
        for (ImplementationSnapshot actionImpl : execution.getTaskActionImplementations()) {
            this.implementationSnapshotSerializer.write(encoder, (Object)actionImpl);
        }
        encoder.writeSmallInt(execution.getOutputPropertyNamesForCacheKey().size());
        for (String outputFile : execution.getOutputPropertyNamesForCacheKey()) {
            encoder.writeString((CharSequence)outputFile);
        }
        this.inputPropertiesSerializer.write(encoder, (ImmutableMap<String, ValueSnapshot>)execution.getInputProperties());
    }

    private ImmutableSortedMap<String, HistoricalFileCollectionFingerprint> readFingerprints(Decoder decoder) throws Exception {
        int count = decoder.readSmallInt();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int fingerprintIdx = 0; fingerprintIdx < count; ++fingerprintIdx) {
            String property = decoder.readString();
            HistoricalFileCollectionFingerprint fingerprint = (HistoricalFileCollectionFingerprint)this.fileCollectionFingerprintSerializer.read(decoder);
            builder.put((Object)property, (Object)fingerprint);
        }
        return builder.build();
    }

    private void writeFingerprints(Encoder encoder, Map<String, HistoricalFileCollectionFingerprint> fingerprints) throws Exception {
        encoder.writeSmallInt(fingerprints.size());
        for (Map.Entry<String, HistoricalFileCollectionFingerprint> entry : fingerprints.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.fileCollectionFingerprintSerializer.write(encoder, (Object)entry.getValue());
        }
    }
}

