/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.Map;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IInvokedMethodListener2;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.Maps;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.invokers.InvokedMethodListenerSubtype;

public class InvokedMethodListenerInvoker {
    private InvokedMethodListenerMethod m_listenerMethod;
    private ITestContext m_testContext;
    private ITestResult m_testResult;
    private static final Map<InvokedMethodListenerSubtype, Map<InvokedMethodListenerMethod, InvocationStrategy>> strategies = Maps.newHashMap();
    private static final Map<InvokedMethodListenerMethod, InvocationStrategy> INVOKE_WITH_CONTEXT_STRATEGIES = Maps.newHashMap();
    private static final Map<InvokedMethodListenerMethod, InvocationStrategy> INVOKE_WITHOUT_CONTEXT_STRATEGIES = Maps.newHashMap();

    public InvokedMethodListenerInvoker(InvokedMethodListenerMethod listenerMethod, ITestResult testResult, ITestContext testContext) {
        this.m_listenerMethod = listenerMethod;
        this.m_testContext = testContext;
        this.m_testResult = testResult;
    }

    public void invokeListener(IInvokedMethodListener listenerInstance, IInvokedMethod invokedMethod) {
        InvocationStrategy strategy = this.obtainStrategyFor(listenerInstance, this.m_listenerMethod);
        strategy.callMethod(listenerInstance, invokedMethod, this.m_testResult, this.m_testContext);
    }

    private InvocationStrategy obtainStrategyFor(IInvokedMethodListener listenerInstance, InvokedMethodListenerMethod listenerMethod) {
        InvokedMethodListenerSubtype invokedMethodListenerSubtype = InvokedMethodListenerSubtype.fromListener(listenerInstance);
        Map<InvokedMethodListenerMethod, InvocationStrategy> strategiesForListenerType = strategies.get((Object)invokedMethodListenerSubtype);
        InvocationStrategy invocationStrategy = strategiesForListenerType.get((Object)listenerMethod);
        return invocationStrategy;
    }

    static {
        INVOKE_WITH_CONTEXT_STRATEGIES.put(InvokedMethodListenerMethod.BEFORE_INVOCATION, new InvokeBeforeInvocationWithContextStrategy());
        INVOKE_WITH_CONTEXT_STRATEGIES.put(InvokedMethodListenerMethod.AFTER_INVOCATION, new InvokeAfterInvocationWithContextStrategy());
        INVOKE_WITHOUT_CONTEXT_STRATEGIES.put(InvokedMethodListenerMethod.BEFORE_INVOCATION, new InvokeBeforeInvocationWithoutContextStrategy());
        INVOKE_WITHOUT_CONTEXT_STRATEGIES.put(InvokedMethodListenerMethod.AFTER_INVOCATION, new InvokeAfterInvocationWithoutContextStrategy());
        strategies.put(InvokedMethodListenerSubtype.EXTENDED_LISTENER, INVOKE_WITH_CONTEXT_STRATEGIES);
        strategies.put(InvokedMethodListenerSubtype.SIMPLE_LISTENER, INVOKE_WITHOUT_CONTEXT_STRATEGIES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvokeAfterInvocationWithContextStrategy
    implements InvocationStrategy<IInvokedMethodListener2> {
        private InvokeAfterInvocationWithContextStrategy() {
        }

        @Override
        public void callMethod(IInvokedMethodListener2 listener, IInvokedMethod invokedMethod, ITestResult testResult, ITestContext testContext) {
            listener.afterInvocation(invokedMethod, testResult, testContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvokeAfterInvocationWithoutContextStrategy
    implements InvocationStrategy<IInvokedMethodListener> {
        private InvokeAfterInvocationWithoutContextStrategy() {
        }

        @Override
        public void callMethod(IInvokedMethodListener listener, IInvokedMethod invokedMethod, ITestResult testResult, ITestContext testContext) {
            listener.afterInvocation(invokedMethod, testResult);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvokeBeforeInvocationWithContextStrategy
    implements InvocationStrategy<IInvokedMethodListener2> {
        private InvokeBeforeInvocationWithContextStrategy() {
        }

        @Override
        public void callMethod(IInvokedMethodListener2 listener, IInvokedMethod invokedMethod, ITestResult testResult, ITestContext testContext) {
            listener.beforeInvocation(invokedMethod, testResult, testContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvokeBeforeInvocationWithoutContextStrategy
    implements InvocationStrategy<IInvokedMethodListener> {
        private InvokeBeforeInvocationWithoutContextStrategy() {
        }

        @Override
        public void callMethod(IInvokedMethodListener listener, IInvokedMethod invokedMethod, ITestResult testResult, ITestContext testContext) {
            listener.beforeInvocation(invokedMethod, testResult);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface InvocationStrategy<LISTENER_TYPE extends IInvokedMethodListener> {
        public void callMethod(LISTENER_TYPE var1, IInvokedMethod var2, ITestResult var3, ITestContext var4);
    }
}

