/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.DeclaredUpperBoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExplicitTypeParameterConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.MutableVariableWithConstraints$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.model.ReceiverConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0006J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00062\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J!\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\"H\u0000\u00a2\u0006\u0002\b#J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J!\u0010&\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\"H\u0000\u00a2\u0006\u0002\b'J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\b\u0010)\u001a\u00020*H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\fj\b\u0012\u0004\u0012\u00020\u0006`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/model/MutableVariableWithConstraints;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "constraints", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "(Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;Ljava/util/Collection;)V", "", "getConstraints", "()Ljava/util/List;", "mutableConstraints", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "projectedInputCallTypes", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "getProjectedInputCallTypes", "()Ljava/util/Collection;", "simplifiedConstraints", "getTypeVariable", "()Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "addConstraint", "constraint", "isUsefulConstraint", "", "equalityConstraints", "", "", "newConstraintIsUseless", "old", "new", "removeConstrains", "", "shouldRemove", "Lkotlin/Function1;", "removeConstrains$resolution", "removeDuplicatesFromDeclaredUpperBoundConstraints", "", "removeLastConstraints", "removeLastConstraints$resolution", "simplifyConstraints", "toString", "", "resolution"})
public final class MutableVariableWithConstraints
implements VariableWithConstraints {
    private final ArrayList<Constraint> mutableConstraints;
    private List<Constraint> simplifiedConstraints;
    @NotNull
    private final TypeVariableMarker typeVariable;

    @Override
    @NotNull
    public List<Constraint> getConstraints() {
        if (this.simplifiedConstraints == null) {
            this.simplifiedConstraints = this.simplifyConstraints();
        }
        List<Constraint> list2 = this.simplifiedConstraints;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<UnwrappedType> getProjectedInputCallTypes() {
        void $this$mapTo$iv$iv;
        Constraint it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.mutableConstraints;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Constraint)element$iv$iv;
            boolean bl = false;
            ConstraintPosition position = it.getPosition().getFrom();
            boolean bl2 = position instanceof ArgumentConstraintPosition || position instanceof ReceiverConstraintPosition || position instanceof ExpectedTypeConstraintPosition || position instanceof ExplicitTypeParameterConstraintPosition;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Constraint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinTypeMarker kotlinTypeMarker = it.getType();
            if (kotlinTypeMarker == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.KotlinType");
            }
            UnwrappedType unwrappedType = TypeUtilsKt.unCapture((KotlinType)kotlinTypeMarker).unwrap();
            collection.add(unwrappedType);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final Constraint addConstraint(@NotNull Constraint constraint) {
        boolean bl;
        block14: {
            boolean bl2;
            List previousConstraintWithSameType;
            block13: {
                Iterator $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
                Iterable $this$filter$iv = this.getConstraints();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    Constraint it = (Constraint)element$iv$iv;
                    boolean bl3 = false;
                    if (!(it.getTypeHashCode() == constraint.getTypeHashCode() && Intrinsics.areEqual((Object)it.getType(), (Object)constraint.getType()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                previousConstraintWithSameType = (List)destination$iv$iv;
                Iterable $this$any$iv = previousConstraintWithSameType;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Constraint previous = (Constraint)element$iv;
                        boolean bl4 = false;
                        if (!this.newConstraintIsUseless(previous, constraint)) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return null;
            }
            Iterable $this$any$iv = previousConstraintWithSameType;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl5;
                    Constraint previous = (Constraint)element$iv;
                    boolean bl6 = false;
                    switch (MutableVariableWithConstraints$WhenMappings.$EnumSwitchMapping$0[previous.getKind().ordinal()]) {
                        case 1: {
                            bl5 = constraint.getKind().isUpper();
                            break;
                        }
                        case 2: {
                            bl5 = constraint.getKind().isLower();
                            break;
                        }
                        case 3: {
                            bl5 = true;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    if (!bl5) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        boolean addAsEqualityConstraint = bl;
        Constraint actualConstraint = addAsEqualityConstraint ? new Constraint(ConstraintKind.EQUALITY, constraint.getType(), constraint.getPosition(), constraint.getTypeHashCode(), constraint.getDerivedFrom()) : constraint;
        this.mutableConstraints.add(actualConstraint);
        this.simplifiedConstraints = null;
        return actualConstraint;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeLastConstraints$resolution(@NotNull Function1<? super Constraint, Boolean> shouldRemove2) {
        int n;
        List list2;
        block1: {
            void $this$indexOfLast$iv;
            Intrinsics.checkParameterIsNotNull(shouldRemove2, (String)"shouldRemove");
            List list3 = this.mutableConstraints;
            list2 = this.mutableConstraints;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                Constraint it = (Constraint)iterator$iv.previous();
                boolean bl = false;
                if (!((Boolean)shouldRemove2.invoke((Object)it) == false)) continue;
                n = iterator$iv.nextIndex();
                break block1;
            }
            n = -1;
        }
        int n2 = n;
        InferenceUtilsKt.trimToSize(list2, n2 + 1);
        this.simplifiedConstraints = null;
    }

    public final void removeConstrains$resolution(@NotNull Function1<? super Constraint, Boolean> shouldRemove2) {
        Intrinsics.checkParameterIsNotNull(shouldRemove2, (String)"shouldRemove");
        CollectionsKt.removeAll((List)this.mutableConstraints, shouldRemove2);
        this.simplifiedConstraints = null;
    }

    private final boolean newConstraintIsUseless(Constraint old, Constraint constraint) {
        boolean bl;
        if (old.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition && !(constraint.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition)) {
            return false;
        }
        switch (MutableVariableWithConstraints$WhenMappings.$EnumSwitchMapping$1[old.getKind().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = constraint.getKind().isLower();
                break;
            }
            case 3: {
                bl = constraint.getKind().isUpper();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final List<Constraint> simplifyConstraints() {
        Iterable $this$groupByTo$iv$iv;
        Constraint it;
        Iterable $this$filterTo$iv$iv;
        List<Constraint> distinctConstraints = this.removeDuplicatesFromDeclaredUpperBoundConstraints((List<Constraint>)this.mutableConstraints);
        Iterable $this$filter$iv = distinctConstraints;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Constraint)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == ConstraintKind.EQUALITY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Constraint)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getTypeHashCode();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object equalityConstraints = destination$iv$iv;
        $this$filter$iv = distinctConstraints;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Constraint)element$iv$iv;
            boolean bl = false;
            if (!this.isUsefulConstraint(it, (Map<Integer, ? extends List<Constraint>>)equalityConstraints)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Constraint> removeDuplicatesFromDeclaredUpperBoundConstraints(List<Constraint> constraints) {
        List currentConstraints = CollectionsKt.toMutableList((Collection)constraints);
        Iterator iterator2 = currentConstraints.iterator();
        while (iterator2.hasNext()) {
            boolean hasDuplicate;
            boolean bl;
            block4: {
                Constraint potentialDuplicate = (Constraint)iterator2.next();
                if (!(potentialDuplicate.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition)) continue;
                Iterable $this$any$iv = currentConstraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Constraint other = (Constraint)element$iv;
                        boolean bl2 = false;
                        if (!(potentialDuplicate != other && potentialDuplicate.getTypeHashCode() == other.getTypeHashCode() && Intrinsics.areEqual((Object)potentialDuplicate.getType(), (Object)other.getType()) && potentialDuplicate.getKind() == other.getKind())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!(hasDuplicate = bl)) continue;
            iterator2.remove();
        }
        return currentConstraints;
    }

    private final boolean isUsefulConstraint(Constraint constraint, Map<Integer, ? extends List<Constraint>> equalityConstraints) {
        boolean bl;
        block6: {
            if (constraint.getKind() == ConstraintKind.EQUALITY) {
                return true;
            }
            List<Constraint> list2 = equalityConstraints.get(constraint.getTypeHashCode());
            if (list2 != null) {
                Iterable $this$none$iv = list2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Constraint it = (Constraint)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)constraint.getType())) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "Constraints for " + this.getTypeVariable();
    }

    @Override
    @NotNull
    public TypeVariableMarker getTypeVariable() {
        return this.typeVariable;
    }

    public MutableVariableWithConstraints(@NotNull TypeVariableMarker typeVariable2, @NotNull Collection<Constraint> constraints) {
        Intrinsics.checkParameterIsNotNull((Object)typeVariable2, (String)"typeVariable");
        Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
        this.typeVariable = typeVariable2;
        this.mutableConstraints = new ArrayList<Constraint>(constraints);
    }

    public /* synthetic */ MutableVariableWithConstraints(TypeVariableMarker typeVariableMarker, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(typeVariableMarker, collection);
    }
}

