/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.CachingTaskInputFileCollection;
import org.gradle.api.internal.file.CalculatedTaskInputFileCollection;
import org.gradle.api.internal.file.DefaultFilePropertyFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TaskFileVarFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.file.PathToFileResolver;

public class DefaultProjectLayout
implements ProjectLayout,
TaskFileVarFactory {
    private final DefaultFilePropertyFactory.FixedDirectory projectDir;
    private final DefaultFilePropertyFactory.DefaultDirectoryVar buildDir;
    private final TaskDependencyFactory taskDependencyFactory;
    private final FileCollectionFactory fileCollectionFactory;

    public DefaultProjectLayout(File projectDir, FileResolver resolver, TaskDependencyFactory taskDependencyFactory, FileCollectionFactory fileCollectionFactory) {
        this.taskDependencyFactory = taskDependencyFactory;
        this.fileCollectionFactory = fileCollectionFactory;
        this.projectDir = new DefaultFilePropertyFactory.FixedDirectory(projectDir, resolver, fileCollectionFactory);
        this.buildDir = new DefaultFilePropertyFactory.DefaultDirectoryVar(resolver, fileCollectionFactory, (Object)"build");
    }

    public Directory getProjectDirectory() {
        return this.projectDir;
    }

    public DirectoryProperty getBuildDirectory() {
        return this.buildDir;
    }

    @Override
    public ConfigurableFileCollection newInputFileCollection(Task consumer) {
        return new CachingTaskInputFileCollection((PathToFileResolver)this.projectDir.fileResolver, (Factory<PatternSet>)this.projectDir.fileResolver.getPatternSetFactory(), this.taskDependencyFactory);
    }

    @Override
    public FileCollection newCalculatedInputFileCollection(Task consumer, MinimalFileSet calculatedFiles, FileCollection ... inputs) {
        return new CalculatedTaskInputFileCollection(consumer.getPath(), calculatedFiles, inputs);
    }

    public Provider<RegularFile> file(Provider<File> provider) {
        return new AbstractMappingProvider<RegularFile, File>(RegularFile.class, Providers.internal(provider)){

            protected RegularFile mapValue(File file) {
                return new DefaultFilePropertyFactory.FixedFile(((DefaultProjectLayout)DefaultProjectLayout.this).projectDir.fileResolver.resolve((Object)file));
            }
        };
    }

    public Provider<Directory> dir(Provider<File> provider) {
        return new AbstractMappingProvider<Directory, File>(Directory.class, Providers.internal(provider)){

            protected Directory mapValue(File file) {
                return new DefaultFilePropertyFactory.FixedDirectory(((DefaultProjectLayout)DefaultProjectLayout.this).projectDir.fileResolver.resolve((Object)file), ((DefaultProjectLayout)DefaultProjectLayout.this).projectDir.fileResolver, DefaultProjectLayout.this.fileCollectionFactory);
            }
        };
    }

    public FileCollection files(Object ... paths) {
        return this.fileCollectionFactory.resolving(paths);
    }

    public ConfigurableFileCollection configurableFiles(Object ... files) {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(ProjectLayout.class, (String)"configurableFiles()").replaceWith((Object)"ObjectFactory.fileCollection()")).withUserManual("lazy_configuration", "property_files_api_reference").nagUser();
        return this.fileCollectionFactory.configurableFiles().from(files);
    }

    public void setBuildDirectory(Object value) {
        this.buildDir.resolveAndSet(value);
    }
}

