/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class DefaultProperty<T>
extends AbstractProperty<T>
implements Property<T> {
    private final Class<T> type;
    private final ValueSanitizer<T> sanitizer;
    private ProviderInternal<? extends T> convention = Providers.notDefined();
    private ProviderInternal<? extends T> valueSupplier;

    public DefaultProperty(Class<T> type) {
        this.applyDefaultValue();
        this.type = type;
        this.sanitizer = ValueSanitizers.forType(type);
    }

    @Override
    protected ValueSupplier getSupplier() {
        return this.valueSupplier;
    }

    @Override
    public Object unpackState() {
        return this.getProvider();
    }

    @Override
    public Class<?> publicType() {
        return Property.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.PropertyManagedFactory.FACTORY_ID;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            this.set(object);
        }
    }

    public void set(T value) {
        if (value == null) {
            if (this.beforeReset()) {
                this.valueSupplier = this.convention;
            }
            return;
        }
        if (this.beforeMutate()) {
            this.valueSupplier = Providers.fixedValue(this.getValidationDisplayName(), value, this.type, this.sanitizer);
        }
    }

    public Property<T> value(@Nullable T value) {
        this.set(value);
        return this;
    }

    public Property<T> value(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    public ProviderInternal<? extends T> getProvider() {
        return this.valueSupplier;
    }

    public DefaultProperty<T> provider(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    public void set(Provider<? extends T> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<T> p = Providers.internal(provider);
        this.valueSupplier = p.asSupplier(this.getValidationDisplayName(), this.type, this.sanitizer);
    }

    public Property<T> convention(T value) {
        if (value == null) {
            this.applyConvention(Providers.notDefined());
        } else {
            this.applyConvention(Providers.fixedValue(this.getValidationDisplayName(), value, this.type, this.sanitizer));
        }
        return this;
    }

    public Property<T> convention(Provider<? extends T> valueProvider) {
        ProviderInternal<? extends T> conventionSupplier = Providers.internal(valueProvider).asSupplier(this.getValidationDisplayName(), this.type, this.sanitizer);
        this.applyConvention(conventionSupplier);
        return this;
    }

    private void applyConvention(ProviderInternal<? extends T> conventionSupplier) {
        if (this.shouldApplyConvention()) {
            this.valueSupplier = conventionSupplier;
        }
        this.convention = conventionSupplier;
    }

    @Override
    protected void applyDefaultValue() {
        this.valueSupplier = Providers.notDefined();
    }

    @Override
    protected void makeFinal() {
        this.valueSupplier = this.valueSupplier.withFinalValue();
        this.convention = Providers.notDefined();
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue() {
        this.beforeRead();
        return this.valueSupplier.calculateValue();
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        return this.valueSupplier.isPresent();
    }

    @Override
    protected String describeContents() {
        return String.format("property(%s, %s)", this.type, this.valueSupplier);
    }
}

