/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.ModuleSources;

abstract class AbstractModuleComponentResolveMetadata
implements ModuleComponentResolveMetadata {
    private final ImmutableAttributesFactory attributesFactory;
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleComponentIdentifier componentIdentifier;
    private final boolean changing;
    private final boolean missing;
    private final List<String> statusScheme;
    private final ImmutableModuleSources moduleSources;
    private final ImmutableList<? extends ComponentVariant> variants;
    private final ImmutableAttributes attributes;
    private final ImmutableList<? extends VirtualComponentIdentifier> platformOwners;
    private final AttributesSchemaInternal schema;
    private final VariantDerivationStrategy variantDerivationStrategy;

    public AbstractModuleComponentResolveMetadata(AbstractMutableModuleComponentResolveMetadata metadata) {
        this.componentIdentifier = metadata.getId();
        this.moduleVersionIdentifier = metadata.getModuleVersionId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSources = ImmutableModuleSources.of(metadata.getSources());
        this.attributesFactory = metadata.getAttributesFactory();
        this.schema = metadata.getAttributesSchema();
        this.attributes = AbstractModuleComponentResolveMetadata.extractAttributes(metadata);
        this.variants = metadata.getVariants();
        this.platformOwners = metadata.getPlatformOwners() == null ? ImmutableList.of() : ImmutableList.copyOf(metadata.getPlatformOwners());
        this.variantDerivationStrategy = metadata.getVariantDerivationStrategy();
    }

    public AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata, ImmutableList<? extends ComponentVariant> variants) {
        this.componentIdentifier = metadata.getId();
        this.moduleVersionIdentifier = metadata.getModuleVersionId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSources = ImmutableModuleSources.of(metadata.getSources());
        this.attributesFactory = metadata.getAttributesFactory();
        this.schema = metadata.getAttributesSchema();
        this.attributes = metadata.getAttributes();
        this.variants = variants;
        this.platformOwners = metadata.getPlatformOwners();
        this.variantDerivationStrategy = metadata.getVariantDerivationStrategy();
    }

    public AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata) {
        this.componentIdentifier = metadata.componentIdentifier;
        this.moduleVersionIdentifier = metadata.moduleVersionIdentifier;
        this.changing = metadata.changing;
        this.missing = metadata.missing;
        this.statusScheme = metadata.statusScheme;
        this.moduleSources = metadata.moduleSources;
        this.attributesFactory = metadata.attributesFactory;
        this.schema = metadata.schema;
        this.attributes = metadata.attributes;
        this.variants = metadata.variants;
        this.platformOwners = metadata.platformOwners;
        this.variantDerivationStrategy = metadata.getVariantDerivationStrategy();
    }

    public AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata, ModuleSources sources, VariantDerivationStrategy derivationStrategy) {
        this.componentIdentifier = metadata.componentIdentifier;
        this.moduleVersionIdentifier = metadata.moduleVersionIdentifier;
        this.changing = metadata.changing;
        this.missing = metadata.missing;
        this.statusScheme = metadata.statusScheme;
        this.attributesFactory = metadata.attributesFactory;
        this.schema = metadata.schema;
        this.attributes = metadata.attributes;
        this.variants = metadata.variants;
        this.platformOwners = metadata.platformOwners;
        this.moduleSources = ImmutableModuleSources.of(sources);
        this.variantDerivationStrategy = derivationStrategy;
    }

    private static ImmutableAttributes extractAttributes(AbstractMutableModuleComponentResolveMetadata metadata) {
        return ((AttributeContainerInternal)metadata.getAttributes()).asImmutable();
    }

    @Override
    public ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ModuleComponentIdentifier getId() {
        return this.componentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public ModuleSources getSources() {
        return this.moduleSources;
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return this.schema;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getStatus() {
        return (String)this.attributes.getAttribute(ProjectInternal.STATUS_ATTRIBUTE);
    }

    @Override
    public ImmutableList<? extends ComponentVariant> getVariants() {
        return this.variants;
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getModuleVersionId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getId(), ivyArtifactName);
    }

    protected Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants() {
        return Optional.absent();
    }

    @Override
    public ImmutableList<? extends VirtualComponentIdentifier> getPlatformOwners() {
        return this.platformOwners;
    }

    @Override
    public VariantDerivationStrategy getVariantDerivationStrategy() {
        return this.variantDerivationStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractModuleComponentResolveMetadata that = (AbstractModuleComponentResolveMetadata)o;
        return this.changing == that.changing && this.missing == that.missing && Objects.equal((Object)this.moduleVersionIdentifier, (Object)that.moduleVersionIdentifier) && Objects.equal((Object)this.componentIdentifier, (Object)that.componentIdentifier) && Objects.equal(this.statusScheme, that.statusScheme) && Objects.equal((Object)this.moduleSources, (Object)that.moduleSources) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.variants, that.variants);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.moduleVersionIdentifier, this.componentIdentifier, this.changing, this.missing, this.statusScheme, this.moduleSources, this.attributes, this.variants});
    }
}

