/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.internal.jni.AbstractFileEventFunctions;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.registry.FileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.DefaultFileWatcherRegistry;

public abstract class AbstractFileWatcherRegistryFactory<T extends AbstractFileEventFunctions>
implements FileWatcherRegistryFactory {
    private static final int FILE_EVENT_QUEUE_SIZE = 4096;
    protected final T fileEventFunctions;

    public AbstractFileWatcherRegistryFactory(T fileEventFunctions) {
        this.fileEventFunctions = fileEventFunctions;
    }

    @Override
    public FileWatcherRegistry createFileWatcherRegistry(FileWatcherRegistry.ChangeHandler handler) {
        ArrayBlockingQueue<FileWatchEvent> fileEvents = new ArrayBlockingQueue<FileWatchEvent>(4096);
        try {
            FileWatcher watcher = this.createFileWatcher(fileEvents);
            FileWatcherUpdater fileWatcherUpdater = this.createFileWatcherUpdater(watcher);
            return new DefaultFileWatcherRegistry(watcher, handler, fileWatcherUpdater, fileEvents);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected abstract FileWatcher createFileWatcher(BlockingQueue<FileWatchEvent> var1) throws InterruptedException;

    protected abstract FileWatcherUpdater createFileWatcherUpdater(FileWatcher var1);
}

