/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.context.DaemonContext;

public class DaemonCompatibilitySpec
implements ExplainingSpec<DaemonContext> {
    private final DaemonContext desiredContext;

    public DaemonCompatibilitySpec(DaemonContext desiredContext) {
        this.desiredContext = desiredContext;
    }

    public boolean isSatisfiedBy(DaemonContext potentialContext) {
        return this.whyUnsatisfied(potentialContext) == null;
    }

    public String whyUnsatisfied(DaemonContext context) {
        if (!this.javaHomeMatches(context)) {
            return "Java home is different.\n" + this.description(context);
        }
        if (!this.daemonOptsMatch(context)) {
            return "At least one daemon option is different.\n" + this.description(context);
        }
        if (!this.priorityMatches(context)) {
            return "Process priority is different.\n" + this.description(context);
        }
        return null;
    }

    private String description(DaemonContext context) {
        return "Wanted: " + this + "\nActual: " + context + "\n";
    }

    private boolean daemonOptsMatch(DaemonContext potentialContext) {
        return potentialContext.getDaemonOpts().containsAll(this.desiredContext.getDaemonOpts()) && potentialContext.getDaemonOpts().size() == this.desiredContext.getDaemonOpts().size();
    }

    private boolean javaHomeMatches(DaemonContext potentialContext) {
        try {
            File potentialJava = Jvm.forHome(potentialContext.getJavaHome()).getJavaExecutable();
            File desiredJava = Jvm.forHome(this.desiredContext.getJavaHome()).getJavaExecutable();
            return Files.isSameFile(potentialJava.toPath(), desiredJava.toPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean priorityMatches(DaemonContext context) {
        return this.desiredContext.getPriority() == context.getPriority();
    }

    public String toString() {
        return this.desiredContext.toString();
    }
}

