/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants.ConstantToDependentsMapping;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants.ConstantToDependentsMappingBuilder;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;

public class ConstantToDependentsMappingMerger {
    public ConstantToDependentsMapping merge(ConstantToDependentsMapping newMapping, @Nullable ConstantToDependentsMapping oldMapping, Set<String> changedClasses) {
        if (oldMapping == null) {
            oldMapping = ConstantToDependentsMapping.empty();
        }
        return this.updateClassToConstantsMapping(newMapping, oldMapping, changedClasses);
    }

    private ConstantToDependentsMapping updateClassToConstantsMapping(ConstantToDependentsMapping newMapping, ConstantToDependentsMapping oldMapping, Set<String> changedClasses) {
        ConstantToDependentsMappingBuilder builder = ConstantToDependentsMapping.builder();
        oldMapping.getConstantDependents().keySet().stream().filter(constantOrigin -> !changedClasses.contains(constantOrigin)).forEach(constantOrigin -> {
            DependentsSet dependents = oldMapping.getConstantDependentsForClass((String)constantOrigin);
            HashSet<String> accessibleDependents = new HashSet<String>(dependents.getAccessibleDependentClasses());
            accessibleDependents.removeIf(changedClasses::contains);
            builder.addAccessibleDependents((String)constantOrigin, (Collection<String>)accessibleDependents);
            HashSet<String> privateDependents = new HashSet<String>(dependents.getPrivateDependentClasses());
            privateDependents.removeIf(changedClasses::contains);
            builder.addPrivateDependents((String)constantOrigin, (Collection<String>)privateDependents);
        });
        newMapping.getConstantDependents().keySet().forEach(constantOrigin -> {
            DependentsSet dependents = newMapping.getConstantDependentsForClass((String)constantOrigin);
            builder.addAccessibleDependents((String)constantOrigin, (Collection<String>)dependents.getAccessibleDependentClasses());
            builder.addPrivateDependents((String)constantOrigin, (Collection<String>)dependents.getPrivateDependentClasses());
        });
        return builder.build();
    }
}

