/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildWorkGraph;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;

public class DefaultBuildWorkGraph
implements BuildWorkGraph {
    private final Object lock = new Object();
    private final Map<String, DefaultExportedTaskNode> nodesByPath = new HashMap<String, DefaultExportedTaskNode>();
    private final TaskExecutionGraphInternal taskGraph;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildLifecycleController controller;
    private boolean tasksScheduled;

    public DefaultBuildWorkGraph(TaskExecutionGraphInternal taskGraph, ProjectStateRegistry projectStateRegistry, BuildLifecycleController controller) {
        this.taskGraph = taskGraph;
        this.projectStateRegistry = projectStateRegistry;
        this.controller = controller;
    }

    @Override
    public ExportedTaskNode locateTask(TaskInternal task) {
        DefaultExportedTaskNode node = this.doLocate(task.getPath());
        node.maybeBindTask(task);
        return node;
    }

    @Override
    public ExportedTaskNode locateTask(String taskPath) {
        return this.doLocate(taskPath);
    }

    @Override
    public void schedule(Collection<ExportedTaskNode> taskNodes) {
        ArrayList<TaskInternal> tasks = new ArrayList<TaskInternal>();
        for (ExportedTaskNode taskNode : taskNodes) {
            DefaultExportedTaskNode node = (DefaultExportedTaskNode)taskNode;
            if (this.nodesByPath.get(node.taskPath) != taskNode) {
                throw new IllegalArgumentException();
            }
            node.whenScheduled();
            tasks.add(node.getTask());
        }
        this.tasksScheduled = true;
        this.projectStateRegistry.withMutableStateOfAllProjects(() -> this.controller.populateWorkGraph(taskGraph -> {
            for (Task task : tasks) {
                taskGraph.addEntryTasks(Collections.singletonList(task));
            }
        }));
    }

    @Override
    public void prepareForExecution() {
        if (this.tasksScheduled) {
            this.taskGraph.populate();
        }
        this.updateTasksPriorToExecution();
    }

    @Override
    public ExecutionResult<Void> execute() {
        try {
            if (this.tasksScheduled) {
                ExecutionResult<Void> executionResult = this.controller.executeTasks();
                return executionResult;
            }
            ExecutionResult<Void> executionResult = ExecutionResult.succeeded();
            return executionResult;
        }
        finally {
            this.updateTasksAfterExecution();
            this.tasksScheduled = false;
        }
    }

    private void updateTasksPriorToExecution() {
        for (DefaultExportedTaskNode value : this.nodesByPath.values()) {
            value.beforeExecution();
        }
    }

    private void updateTasksAfterExecution() {
        for (DefaultExportedTaskNode value : this.nodesByPath.values()) {
            value.afterExecution();
        }
    }

    private DefaultExportedTaskNode doLocate(String taskPath) {
        return this.nodesByPath.computeIfAbsent(taskPath, x$0 -> new DefaultExportedTaskNode((String)x$0));
    }

    private TaskInternal getTask(String taskPath) {
        TaskInternal task = this.findTaskInWorkGraph(taskPath);
        if (task == null) {
            throw new IllegalStateException("Root build task '" + taskPath + "' was never scheduled for execution.");
        }
        return task;
    }

    private IllegalStateException includedBuildTaskWasNeverScheduled(String taskPath) {
        return new IllegalStateException("Included build task '" + taskPath + "' was never scheduled for execution.");
    }

    private TaskInternal findTaskInWorkGraph(String taskPath) {
        for (Task task : this.taskGraph.getAllTasks()) {
            if (!task.getPath().equals(taskPath)) continue;
            return (TaskInternal)task;
        }
        return null;
    }

    private class DefaultExportedTaskNode
    implements ExportedTaskNode {
        final String taskPath;
        TaskInternal task;
        TaskState state = TaskState.Idle;

        DefaultExportedTaskNode(String taskPath) {
            this.taskPath = taskPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeBindTask(TaskInternal task) {
            Object object = DefaultBuildWorkGraph.this.lock;
            synchronized (object) {
                if (this.task == null) {
                    this.task = task;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TaskInternal getTask() {
            Object object = DefaultBuildWorkGraph.this.lock;
            synchronized (object) {
                if (this.task == null) {
                    this.task = DefaultBuildWorkGraph.this.getTask(this.taskPath);
                }
                return this.task;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IncludedBuildTaskResource.State getTaskState() {
            Object object = DefaultBuildWorkGraph.this.lock;
            synchronized (object) {
                if (this.state == TaskState.NotScheduled) {
                    return IncludedBuildTaskResource.State.SUCCESS;
                }
                if (this.state == TaskState.Idle) {
                    return IncludedBuildTaskResource.State.WAITING;
                }
                this.getTask();
                if (this.task.getState().getFailure() != null) {
                    return IncludedBuildTaskResource.State.FAILED;
                }
                if (this.task.getState().getExecuted()) {
                    return IncludedBuildTaskResource.State.SUCCESS;
                }
                if (this.state == TaskState.Finished) {
                    return IncludedBuildTaskResource.State.FAILED;
                }
                return IncludedBuildTaskResource.State.WAITING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void whenScheduled() {
            Object object = DefaultBuildWorkGraph.this.lock;
            synchronized (object) {
                this.state = TaskState.Scheduled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeExecution() {
            Object object = DefaultBuildWorkGraph.this.lock;
            synchronized (object) {
                if (this.state == TaskState.Idle) {
                    this.state = TaskState.NotScheduled;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterExecution() {
            Object object = DefaultBuildWorkGraph.this.lock;
            synchronized (object) {
                if (this.state == TaskState.Scheduled) {
                    this.state = TaskState.Finished;
                } else if (this.state == TaskState.NotScheduled) {
                    this.state = TaskState.Idle;
                }
            }
        }
    }

    private static enum TaskState {
        Idle,
        NotScheduled,
        Scheduled,
        Finished;

    }
}

