/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDelegatedPropertyChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirDelegatedPropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDelegatedPropertyChecker INSTANCE = new FirDelegatedPropertyChecker();

    private FirDelegatedPropertyChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker$check$DelegatedPropertyAccessorVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "isGet", "", "(Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Z)V", "checkReturnType", "", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "hasFunctionReferenceErrors", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "checkers"})
        public final class DelegatedPropertyAccessorVisitor
        extends FirVisitorVoid {
            private final boolean isGet;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ ConeKotlinType $delegateType;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ FirProperty $declaration;
            final /* synthetic */ FirExpression $delegate;

            public DelegatedPropertyAccessorVisitor(@NotNull DiagnosticReporter $reporter, @NotNull ConeKotlinType $delegateType, @NotNull CheckerContext $context, @NotNull FirProperty $declaration, @NotNull FirExpression $delegate, boolean isGet) {
                Intrinsics.checkNotNullParameter((Object)$reporter, (String)"$reporter");
                Intrinsics.checkNotNullParameter((Object)$delegateType, (String)"$delegateType");
                Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                Intrinsics.checkNotNullParameter((Object)$declaration, (String)"$declaration");
                Intrinsics.checkNotNullParameter((Object)$delegate, (String)"$delegate");
                this.$reporter = $reporter;
                this.$delegateType = $delegateType;
                this.$context = $context;
                this.$declaration = $declaration;
                this.$delegate = $delegate;
                this.isGet = isGet;
            }

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren(this);
            }

            public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                boolean hasReferenceError = this.hasFunctionReferenceErrors(functionCall);
                if (this.isGet && !hasReferenceError) {
                    this.checkReturnType(functionCall);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final boolean hasFunctionReferenceErrors(FirFunctionCall functionCall) {
                boolean bl;
                Object object;
                FirNamedReference firNamedReference = functionCall.getCalleeReference();
                Object object2 = object = firNamedReference instanceof FirErrorNamedReference ? (FirErrorNamedReference)firNamedReference : null;
                if (object == null) {
                    return false;
                }
                Object errorNamedReference = object;
                if (!Intrinsics.areEqual((Object)((object = ((FirErrorNamedReference)errorNamedReference).getSource()) == null ? null : ((FirSourceElement)object).getKind()), (Object)FirFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                    return false;
                }
                FirCall $this$arguments$iv = functionCall;
                boolean $i$f$getArguments = false;
                String expectedFunctionSignature2 = (this.isGet ? "getValue" : "setValue") + '(' + CollectionsKt.joinToString$default((Iterable)$this$arguments$iv.getArgumentList().getArguments(), (CharSequence)", ", null, null, (int)0, null, (Function1)check.DelegatedPropertyAccessorVisitor.hasFunctionReferenceErrors.expectedFunctionSignature.1.INSTANCE, (int)30, null) + ')';
                String delegateDescription = this.isGet ? "delegate" : "delegate for var (read-write property)";
                ConeDiagnostic diagnostic = ((FirErrorNamedReference)errorNamedReference).getDiagnostic();
                if (diagnostic instanceof ConeUnresolvedNameError) {
                    DiagnosticReporterKt.reportOn$default(this.$reporter, ((FirErrorNamedReference)errorNamedReference).getSource(), FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_MISSING(), expectedFunctionSignature2, this.$delegateType, delegateDescription, this.$context, null, 64, null);
                    bl = true;
                } else if (diagnostic instanceof ConeAmbiguityError) {
                    if (CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability())) {
                        Collection<AbstractFirBasedSymbol<?>> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
                        String string2 = expectedFunctionSignature2;
                        FirDiagnosticFactory2<String, Collection<AbstractFirBasedSymbol<?>>> firDiagnosticFactory2 = FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_AMBIGUITY();
                        FirSourceElement firSourceElement = ((FirErrorNamedReference)errorNamedReference).getSource();
                        DiagnosticReporter diagnosticReporter = this.$reporter;
                        boolean $i$f$map = false;
                        void var8_19 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Candidate candidate2 = (Candidate)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            AbstractFirBasedSymbol<?> abstractFirBasedSymbol = it.getSymbol();
                            collection.add(abstractFirBasedSymbol);
                        }
                        collection = (List)destination$iv$iv;
                        DiagnosticReporterKt.reportOn$default(diagnosticReporter, firSourceElement, firDiagnosticFactory2, string2, collection, this.$context, null, 32, null);
                    } else {
                        Collection<AbstractFirBasedSymbol<?>> collection;
                        Iterable $this$map$iv = ((ConeAmbiguityError)diagnostic).getCandidates();
                        CandidateApplicability candidateApplicability = ((ConeAmbiguityError)diagnostic).getApplicability();
                        CheckerContext checkerContext = this.$context;
                        String string3 = delegateDescription;
                        ConeKotlinType coneKotlinType = this.$delegateType;
                        String string4 = expectedFunctionSignature2;
                        FirErrorNamedReference firErrorNamedReference = errorNamedReference;
                        DiagnosticReporter diagnosticReporter = this.$reporter;
                        boolean $i$f$map = false;
                        Iterable $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            Candidate it = (Candidate)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            AbstractFirBasedSymbol<?> abstractFirBasedSymbol = it.getSymbol();
                            collection.add(abstractFirBasedSymbol);
                        }
                        collection = (List)destination$iv$iv;
                        DelegatedPropertyAccessorVisitor.hasFunctionReferenceErrors$reportInapplicableDiagnostics(diagnosticReporter, firErrorNamedReference, string4, coneKotlinType, string3, checkerContext, candidateApplicability, (Collection)collection);
                    }
                    bl = true;
                } else if (diagnostic instanceof ConeInapplicableCandidateError) {
                    DelegatedPropertyAccessorVisitor.hasFunctionReferenceErrors$reportInapplicableDiagnostics(this.$reporter, (FirErrorNamedReference)errorNamedReference, expectedFunctionSignature2, this.$delegateType, delegateDescription, this.$context, ((ConeInapplicableCandidateError)diagnostic).getApplicability(), CollectionsKt.listOf(((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol()));
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            private final void checkReturnType(FirFunctionCall functionCall) {
                ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(functionCall.getTypeRef());
                ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(this.$declaration.getReturnTypeRef());
                if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, SessionUtilsKt.getTypeContext(this.$context.getSession()), (KotlinTypeMarker)returnType2, (KotlinTypeMarker)propertyType, false, 8, null)) {
                    DiagnosticReporterKt.reportOn$default(this.$reporter, this.$delegate.getSource(), FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH(), "getValue", propertyType, returnType2, this.$context, null, 64, null);
                }
            }

            private static final void hasFunctionReferenceErrors$reportInapplicableDiagnostics(DiagnosticReporter $reporter, FirErrorNamedReference errorNamedReference, String expectedFunctionSignature2, ConeKotlinType delegateType, String delegateDescription, CheckerContext $context, CandidateApplicability candidateApplicability, Collection<? extends AbstractFirBasedSymbol<?>> candidates2) {
                if (candidateApplicability == CandidateApplicability.INAPPLICABLE_WRONG_RECEIVER) {
                    DiagnosticReporterKt.reportOn$default($reporter, errorNamedReference.getSource(), FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_MISSING(), expectedFunctionSignature2, delegateType, delegateDescription, $context, null, 64, null);
                } else {
                    DiagnosticReporterKt.reportOn$default($reporter, errorNamedReference.getSource(), FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE(), expectedFunctionSignature2, candidates2, $context, null, 32, null);
                }
            }
        }
        FirBlock firBlock;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirExpression firExpression2 = declaration2.getDelegate();
        if (firExpression2 == null) {
            return;
        }
        FirExpression delegate2 = firExpression2;
        ConeKotlinType delegateType = FirTypeUtilsKt.getConeType(delegate2.getTypeRef());
        if (delegateType instanceof ConeClassErrorType) {
            ConeDiagnostic coneDiagnostic;
            ConeSimpleDiagnostic coneSimpleDiagnostic;
            FirSourceElement delegateSource = delegate2.getSource();
            if (delegateSource != null && ((coneSimpleDiagnostic = (coneDiagnostic = ((ConeClassErrorType)delegateType).getDiagnostic()) instanceof ConeSimpleDiagnostic ? (ConeSimpleDiagnostic)coneDiagnostic : null) == null ? null : coneSimpleDiagnostic.getKind()) == DiagnosticKind.RecursionInImplicitTypes) {
                DiagnosticReporterKt.reportOn$default(reporter, delegateSource, FirErrors.INSTANCE.getRECURSION_IN_IMPLICIT_TYPES(), context2, null, 8, null);
            }
            return;
        }
        FirPropertyAccessor firPropertyAccessor = declaration2.getGetter();
        if (firPropertyAccessor != null && (firBlock = firPropertyAccessor.getBody()) != null) {
            firBlock.acceptChildren(new DelegatedPropertyAccessorVisitor(reporter, delegateType, context2, declaration2, delegate2, true));
        }
        if ((firPropertyAccessor = declaration2.getSetter()) != null && (firBlock = firPropertyAccessor.getBody()) != null) {
            firBlock.acceptChildren(new DelegatedPropertyAccessorVisitor(reporter, delegateType, context2, declaration2, delegate2, false));
        }
    }
}

