/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.vfs.WatchMode;

public interface FileWatcherRegistry
extends Closeable {
    public void registerWatchableHierarchy(File var1, SnapshotHierarchy var2);

    public void virtualFileSystemContentsChanged(Collection<FileSystemLocationSnapshot> var1, Collection<FileSystemLocationSnapshot> var2, SnapshotHierarchy var3);

    @CheckReturnValue
    public SnapshotHierarchy updateVfsOnBuildStarted(SnapshotHierarchy var1, WatchMode var2, List<File> var3);

    @CheckReturnValue
    public SnapshotHierarchy updateVfsOnBuildFinished(SnapshotHierarchy var1, WatchMode var2, int var3, List<File> var4);

    public FileWatchingStatistics getAndResetStatistics();

    public void setDebugLoggingEnabled(boolean var1);

    @Override
    public void close() throws IOException;

    public static interface FileWatchingStatistics {
        public Optional<Throwable> getErrorWhileReceivingFileChanges();

        public boolean isUnknownEventEncountered();

        public int getNumberOfReceivedEvents();

        public int getNumberOfWatchedHierarchies();
    }

    public static enum Type {
        CREATED,
        MODIFIED,
        REMOVED,
        INVALIDATED,
        OVERFLOW;

    }

    public static interface ChangeHandler {
        public void handleChange(Type var1, Path var2);

        public void stopWatchingAfterError();
    }
}

