/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.tasks.DefaultScalaSourceSet;
import org.gradle.api.internal.tasks.scala.DefaultScalaPluginExtension;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.plugins.scala.ScalaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.api.tasks.ScalaSourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.language.scala.tasks.AbstractScalaCompile;
import org.gradle.language.scala.tasks.KeepAliveMode;

public abstract class ScalaBasePlugin
implements Plugin<Project> {
    public static final String DEFAULT_ZINC_VERSION = "1.6.1";
    private static final String DEFAULT_SCALA_ZINC_VERSION = "2.13";
    @VisibleForTesting
    public static final String ZINC_CONFIGURATION_NAME = "zinc";
    public static final String SCALA_RUNTIME_EXTENSION_NAME = "scalaRuntime";
    public static final String SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME = "scalaCompilerPlugins";
    private final ObjectFactory objectFactory;
    private final JvmEcosystemUtilities jvmEcosystemUtilities;

    @Inject
    public ScalaBasePlugin(ObjectFactory objectFactory, JvmEcosystemUtilities jvmEcosystemUtilities) {
        this.objectFactory = objectFactory;
        this.jvmEcosystemUtilities = jvmEcosystemUtilities;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        ScalaRuntime scalaRuntime = (ScalaRuntime)project.getExtensions().create(SCALA_RUNTIME_EXTENSION_NAME, ScalaRuntime.class, new Object[]{project});
        ScalaPluginExtension scalaPluginExtension = (ScalaPluginExtension)project.getExtensions().create(ScalaPluginExtension.class, "scala", DefaultScalaPluginExtension.class, new Object[0]);
        Usage incrementalAnalysisUsage = (Usage)this.objectFactory.named(Usage.class, "incremental-analysis");
        Category incrementalAnalysisCategory = (Category)this.objectFactory.named(Category.class, "scala-analysis");
        this.configureConfigurations(project, incrementalAnalysisCategory, incrementalAnalysisUsage, scalaPluginExtension);
        ScalaBasePlugin.configureCompileDefaults(project, scalaRuntime, (DefaultJavaPluginExtension)ScalaBasePlugin.extensionOf((ExtensionAware)project, JavaPluginExtension.class));
        this.configureSourceSetDefaults(project, incrementalAnalysisCategory, incrementalAnalysisUsage, this.objectFactory, scalaRuntime);
        this.configureScaladoc(project, scalaRuntime);
    }

    private void configureConfigurations(Project project, Category incrementalAnalysisCategory, Usage incrementalAnalysisUsage, ScalaPluginExtension scalaPluginExtension) {
        DependencyHandler dependencyHandler = project.getDependencies();
        ConfigurationInternal plugins = (ConfigurationInternal)project.getConfigurations().create(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME);
        plugins.setTransitive(false);
        plugins.setCanBeConsumed(false);
        this.jvmEcosystemUtilities.configureAsRuntimeClasspath((HasConfigurableAttributes)plugins);
        Configuration zinc = (Configuration)project.getConfigurations().create(ZINC_CONFIGURATION_NAME);
        zinc.setVisible(false);
        zinc.setDescription("The Zinc incremental compiler to be used for this Scala project.");
        zinc.setCanBeConsumed(false);
        zinc.getResolutionStrategy().eachDependency(rule -> {
            if (rule.getRequested().getGroup().equals("com.typesafe.zinc") && rule.getRequested().getName().equals(ZINC_CONFIGURATION_NAME)) {
                rule.useTarget((Object)"org.scala-sbt:zinc_2.13:1.6.1");
                rule.because("Typesafe Zinc is no longer maintained.");
            }
        });
        zinc.defaultDependencies(dependencies -> {
            dependencies.add((Object)dependencyHandler.create((Object)("org.scala-sbt:zinc_2.13:" + (String)scalaPluginExtension.getZincVersion().get())));
            zinc.getIncoming().afterResolve(resolvableDependencies -> resolvableDependencies.getResolutionResult().allComponents(component -> {
                if (component.getModuleVersion() != null && component.getModuleVersion().getName().equals("scala-library") && !component.getModuleVersion().getVersion().startsWith(DEFAULT_SCALA_ZINC_VERSION)) {
                    throw new InvalidUserCodeException("The version of 'scala-library' was changed while using the default Zinc version. Version " + component.getModuleVersion().getVersion() + " is not compatible with org.scala-sbt:zinc_" + DEFAULT_SCALA_ZINC_VERSION + ":" + DEFAULT_ZINC_VERSION);
                }
            }));
        });
        zinc.getDependencyConstraints().add((Object)dependencyHandler.getConstraints().create((Object)"org.apache.logging.log4j:log4j-core", constraint -> constraint.version(version -> {
            version.require("2.17.1");
            version.reject(new String[]{"[2.0, 2.17.1)"});
        })));
        Configuration incrementalAnalysisElements = (Configuration)project.getConfigurations().create("incrementalScalaAnalysisElements");
        incrementalAnalysisElements.setVisible(false);
        incrementalAnalysisElements.setDescription("Incremental compilation analysis files");
        incrementalAnalysisElements.setCanBeResolved(false);
        incrementalAnalysisElements.setCanBeConsumed(true);
        incrementalAnalysisElements.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)incrementalAnalysisCategory);
        incrementalAnalysisElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)incrementalAnalysisUsage);
        AttributeMatchingStrategy matchingStrategy = dependencyHandler.getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE);
        matchingStrategy.getDisambiguationRules().add(UsageDisambiguationRules.class, actionConfiguration -> {
            actionConfiguration.params(new Object[]{incrementalAnalysisUsage});
            actionConfiguration.params(new Object[]{this.objectFactory.named(Usage.class, "java-api")});
            actionConfiguration.params(new Object[]{this.objectFactory.named(Usage.class, "java-runtime")});
        });
    }

    private void configureSourceSetDefaults(final Project project, final Category incrementalAnalysisCategory, final Usage incrementalAnalysisUsage, final ObjectFactory objectFactory, final ScalaRuntime scalaRuntime) {
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(SourceSet sourceSet) {
                String displayName = (String)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getDisplayName", null);
                Convention sourceSetConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
                DefaultScalaSourceSet scalaSourceSet = (DefaultScalaSourceSet)objectFactory.newInstance(DefaultScalaSourceSet.class, new Object[]{displayName, objectFactory});
                sourceSetConvention.getPlugins().put("scala", scalaSourceSet);
                sourceSet.getExtensions().add(ScalaSourceDirectorySet.class, "scala", (Object)scalaSourceSet.getScala());
                ScalaSourceDirectorySet scalaDirectorySet = scalaSourceSet.getScala();
                scalaDirectorySet.srcDir(project.file((Object)("src/" + sourceSet.getName() + "/scala")));
                sourceSet.getAllJava().source((SourceDirectorySet)scalaDirectorySet);
                sourceSet.getAllSource().source((SourceDirectorySet)scalaDirectorySet);
                ScalaSourceDirectorySet scalaSource = scalaDirectorySet;
                sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(arg_0 -> 1.lambda$execute$8e3b8c4f$1((FileCollection)scalaSource, arg_0)));
                Configuration classpath = project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName());
                Configuration incrementalAnalysis = (Configuration)project.getConfigurations().create("incrementalScalaAnalysisFor" + sourceSet.getName());
                incrementalAnalysis.setVisible(false);
                incrementalAnalysis.setDescription("Incremental compilation analysis files for " + displayName);
                incrementalAnalysis.setCanBeResolved(true);
                incrementalAnalysis.setCanBeConsumed(false);
                incrementalAnalysis.extendsFrom(new Configuration[]{classpath});
                incrementalAnalysis.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)incrementalAnalysisCategory);
                incrementalAnalysis.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)incrementalAnalysisUsage);
                ScalaBasePlugin.this.configureScalaCompile(project, sourceSet, incrementalAnalysis, incrementalAnalysisUsage, scalaRuntime);
            }

            private static /* synthetic */ boolean lambda$execute$8e3b8c4f$1(FileCollection scalaSource, FileTreeElement element) {
                return scalaSource.contains(element.getFile());
            }
        });
    }

    private void configureScalaCompile(Project project, SourceSet sourceSet, Configuration incrementalAnalysis, Usage incrementalAnalysisUsage, ScalaRuntime scalaRuntime) {
        ScalaSourceDirectorySet scalaSourceSet = (ScalaSourceDirectorySet)sourceSet.getExtensions().getByType(ScalaSourceDirectorySet.class);
        TaskProvider scalaCompileTask = project.getTasks().register(sourceSet.getCompileTaskName("scala"), ScalaCompile.class, scalaCompile -> {
            JvmPluginsHelper.configureForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)scalaSourceSet, (AbstractCompile)scalaCompile, (CompileOptions)scalaCompile.getOptions(), (Project)project);
            scalaCompile.setDescription("Compiles the " + scalaSourceSet + ".");
            scalaCompile.setSource((FileTree)scalaSourceSet);
            scalaCompile.getJavaLauncher().convention(ScalaBasePlugin.getJavaLauncher(project));
            scalaCompile.getAnalysisMappingFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".mapping"));
            IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
            incrementalOptions.getAnalysisFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".analysis"));
            incrementalOptions.getClassfileBackupDir().set(project.getLayout().getBuildDirectory().file("tmp/scala/classfileBackup/" + scalaCompile.getName() + ".bak"));
            Jar jarTask = (Jar)project.getTasks().findByName(sourceSet.getJarTaskName());
            if (jarTask != null) {
                incrementalOptions.getPublishedCode().set(jarTask.getArchiveFile());
            }
            scalaCompile.getAnalysisFiles().from(new Object[]{incrementalAnalysis.getIncoming().artifactView(viewConfiguration -> {
                viewConfiguration.lenient(true);
                viewConfiguration.componentFilter((Spec)new IsProjectComponent());
            }).getFiles()});
            scalaCompile.dependsOn(new Object[]{scalaCompile.getAnalysisFiles()});
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)scalaSourceSet, (Project)project, (TaskProvider)scalaCompileTask, (Provider)scalaCompileTask.map(AbstractScalaCompile::getOptions));
        project.getTasks().named(sourceSet.getClassesTaskName(), task -> task.dependsOn(new Object[]{scalaCompileTask}));
    }

    private static void configureCompileDefaults(Project project, ScalaRuntime scalaRuntime, DefaultJavaPluginExtension javaExtension) {
        project.getTasks().withType(ScalaCompile.class).configureEach(compile -> {
            ConventionMapping conventionMapping = compile.getConventionMapping();
            conventionMapping.map("scalaClasspath", () -> scalaRuntime.inferScalaClasspath((Iterable<File>)compile.getClasspath()));
            conventionMapping.map("zincClasspath", () -> project.getConfigurations().getAt(ZINC_CONFIGURATION_NAME));
            conventionMapping.map(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME, () -> project.getConfigurations().getAt(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME));
            conventionMapping.map("sourceCompatibility", () -> ScalaBasePlugin.computeJavaSourceCompatibilityConvention(javaExtension, compile).toString());
            conventionMapping.map("targetCompatibility", () -> ScalaBasePlugin.computeJavaTargetCompatibilityConvention(javaExtension, compile).toString());
            compile.getScalaCompileOptions().getKeepAliveMode().convention((Object)KeepAliveMode.SESSION);
        });
    }

    private static JavaVersion computeJavaSourceCompatibilityConvention(DefaultJavaPluginExtension javaExtension, ScalaCompile compileTask) {
        JavaVersion rawSourceCompatibility = javaExtension.getRawSourceCompatibility();
        if (rawSourceCompatibility != null) {
            return rawSourceCompatibility;
        }
        return JavaVersion.toVersion((Object)((JavaLauncher)compileTask.getJavaLauncher().get()).getMetadata().getLanguageVersion().toString());
    }

    private static JavaVersion computeJavaTargetCompatibilityConvention(DefaultJavaPluginExtension javaExtension, ScalaCompile compileTask) {
        JavaVersion rawTargetCompatibility = javaExtension.getRawTargetCompatibility();
        if (rawTargetCompatibility != null) {
            return rawTargetCompatibility;
        }
        return JavaVersion.toVersion((Object)compileTask.getSourceCompatibility());
    }

    private void configureScaladoc(Project project, ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaDoc.class).configureEach(scalaDoc -> {
            scalaDoc.getConventionMapping().map("destinationDir", () -> ((Directory)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getDocsDir().dir("scaladoc").get()).getAsFile());
            scalaDoc.getConventionMapping().map("title", () -> ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle());
            scalaDoc.getConventionMapping().map("scalaClasspath", () -> scalaRuntime.inferScalaClasspath((Iterable<File>)scalaDoc.getClasspath()));
            scalaDoc.getJavaLauncher().convention(ScalaBasePlugin.getJavaLauncher(project));
        });
    }

    private static Provider<JavaLauncher> getJavaLauncher(Project project) {
        JavaPluginExtension extension = ScalaBasePlugin.extensionOf((ExtensionAware)project, JavaPluginExtension.class);
        JavaToolchainService service = ScalaBasePlugin.extensionOf((ExtensionAware)project, JavaToolchainService.class);
        return service.launcherFor(extension.getToolchain());
    }

    private static <T> T extensionOf(ExtensionAware extensionAware, Class<T> type) {
        return (T)extensionAware.getExtensions().getByType(type);
    }

    private static class IsProjectComponent
    implements Spec<ComponentIdentifier> {
        private IsProjectComponent() {
        }

        public boolean isSatisfiedBy(ComponentIdentifier element) {
            return element instanceof ProjectComponentIdentifier;
        }
    }

    static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage> {
        private final ImmutableSet<Usage> expectedUsages;
        private final Usage javaRuntime;

        @Inject
        UsageDisambiguationRules(Usage incrementalAnalysis, Usage javaApi, Usage javaRuntime) {
            this.javaRuntime = javaRuntime;
            this.expectedUsages = ImmutableSet.of((Object)incrementalAnalysis, (Object)javaApi, (Object)javaRuntime);
        }

        public void execute(MultipleCandidatesDetails<Usage> details) {
            if (details.getConsumerValue() == null && details.getCandidateValues().equals(this.expectedUsages)) {
                details.closestMatch((Object)this.javaRuntime);
            }
        }
    }
}

