/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.Set;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedFileCollectionVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildSession.class)
public class ArtifactSetToFileCollectionFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final TaskDependencyFactory taskDependencyFactory;

    public ArtifactSetToFileCollectionFactory(TaskDependencyFactory taskDependencyFactory, BuildOperationExecutor buildOperationExecutor) {
        this.taskDependencyFactory = taskDependencyFactory;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public FileCollectionInternal asFileCollection(final ResolvedArtifactSet artifacts) {
        return new AbstractFileCollection(this.taskDependencyFactory){

            public String getDisplayName() {
                return "files";
            }

            protected void visitContents(FileCollectionStructureVisitor visitor) {
                ResolvedFileCollectionVisitor collectingVisitor = new ResolvedFileCollectionVisitor(visitor);
                ParallelResolveArtifactSet.wrap(artifacts, ArtifactSetToFileCollectionFactory.this.buildOperationExecutor).visit(collectingVisitor);
                if (!collectingVisitor.getFailures().isEmpty()) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)collectingVisitor.getFailures().iterator().next());
                }
            }
        };
    }

    public Set<ResolvedArtifactResult> asResolvedArtifacts(ResolvedArtifactSet artifacts) {
        ResolvedArtifactCollectingVisitor collectingVisitor = new ResolvedArtifactCollectingVisitor();
        ParallelResolveArtifactSet.wrap(artifacts, this.buildOperationExecutor).visit(collectingVisitor);
        if (!collectingVisitor.getFailures().isEmpty()) {
            throw UncheckedException.throwAsUncheckedException((Throwable)collectingVisitor.getFailures().iterator().next());
        }
        return collectingVisitor.getArtifacts();
    }
}

