/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.rubygrapefruit.platform.NativeException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.ProcessBuilderFactory;
import org.gradle.process.internal.StreamsHandler;

public class ExecHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecHandleRunner.class);
    private final ProcessBuilderFactory processBuilderFactory;
    private final DefaultExecHandle execHandle;
    private final Lock lock = new ReentrantLock();
    private final Executor executor;
    private Process process;
    private boolean aborted;
    private final StreamsHandler streamsHandler;
    private volatile BuildOperationRef associatedBuildOperation;

    public ExecHandleRunner(DefaultExecHandle execHandle, StreamsHandler streamsHandler, Executor executor, BuildOperationRef associatedBuildOperation) {
        if (execHandle == null) {
            throw new IllegalArgumentException("execHandle == null!");
        }
        this.execHandle = execHandle;
        this.streamsHandler = streamsHandler;
        this.executor = executor;
        this.associatedBuildOperation = associatedBuildOperation;
        this.processBuilderFactory = new ProcessBuilderFactory();
    }

    public void abortProcess() {
        this.lock.lock();
        try {
            if (this.aborted) {
                return;
            }
            this.aborted = true;
            if (this.process != null) {
                this.streamsHandler.disconnect();
                LOGGER.debug("Abort requested. Destroying process: {}.", (Object)this.execHandle.getDisplayName());
                this.process.destroy();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        try {
            CurrentBuildOperationRef.instance().with(this.associatedBuildOperation, () -> {
                this.startProcess();
                this.execHandle.started();
                LOGGER.debug("waiting until streams are handled...");
                this.streamsHandler.start();
            });
            if (this.execHandle.isDaemon()) {
                CurrentBuildOperationRef.instance().with(this.associatedBuildOperation, () -> {
                    this.streamsHandler.stop();
                    this.detached();
                });
            } else {
                int exitValue = this.process.waitFor();
                CurrentBuildOperationRef.instance().with(this.associatedBuildOperation, () -> {
                    this.streamsHandler.stop();
                    this.completed(exitValue);
                });
            }
        }
        catch (Throwable t) {
            CurrentBuildOperationRef.instance().with(this.associatedBuildOperation, () -> this.execHandle.failed(t));
        }
    }

    public void removeStartupContext() {
        this.associatedBuildOperation = null;
        this.streamsHandler.removeStartupContext();
    }

    private void startProcess() {
        this.lock.lock();
        try {
            if (this.aborted) {
                throw new IllegalStateException("Process has already been aborted");
            }
            ProcessBuilder processBuilder = this.processBuilderFactory.createProcessBuilder(this.execHandle);
            Process process = this.start(processBuilder);
            this.streamsHandler.connectStreams(process, this.execHandle.getDisplayName(), this.executor);
            this.process = process;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Process start(ProcessBuilder processBuilder) {
        try {
            return processBuilder.start();
        }
        catch (Exception e) {
            throw new NativeException(String.format("Could not start '%s'", processBuilder.command().get(0)), (Throwable)e);
        }
    }

    private void completed(int exitValue) {
        if (this.aborted) {
            this.execHandle.aborted(exitValue);
        } else {
            this.execHandle.finished(exitValue);
        }
    }

    private void detached() {
        this.execHandle.detached();
    }
}

