/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.Describables;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class VariantResolvingArtifactSet
implements ArtifactSet {
    private final VariantArtifactResolver variantResolver;
    private final ComponentGraphResolveState component;
    private final VariantGraphResolveState variant;
    private final ComponentIdentifier componentId;
    private final ImmutableAttributesSchema producerSchema;
    private final ImmutableAttributes overriddenAttributes;
    private final List<IvyArtifactName> artifacts;
    private final ExcludeSpec exclusions;
    private final Set<CapabilitySelector> capabilitySelectors;
    private final GraphVariantSelector graphVariantSelector;
    private final ImmutableAttributesSchema consumerSchema;
    private final CalculatedValue<ImmutableList<ResolvedVariant>> ownArtifacts;

    public VariantResolvingArtifactSet(VariantArtifactResolver variantResolver, ComponentGraphResolveState component, VariantGraphResolveState variant, DependencyGraphEdge dependency, GraphVariantSelector graphVariantSelector, ImmutableAttributesSchema consumerSchema, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.variantResolver = variantResolver;
        this.component = component;
        this.variant = variant;
        this.componentId = component.getId();
        this.producerSchema = component.getMetadata().getAttributesSchema();
        this.overriddenAttributes = dependency.getAttributes();
        this.artifacts = dependency.getDependencyMetadata().getArtifacts();
        this.exclusions = dependency.getExclusions();
        this.capabilitySelectors = dependency.getSelector().getRequested().getCapabilitySelectors();
        this.graphVariantSelector = graphVariantSelector;
        this.consumerSchema = consumerSchema;
        this.ownArtifacts = calculatedValueContainerFactory.create(Describables.of((Object)"artifacts for"), context -> this.calculateOwnArtifacts());
    }

    @Override
    public ResolvedArtifactSet select(ArtifactVariantSelector variantSelector, ArtifactSelectionSpec spec) {
        ImmutableList<ResolvedVariant> variants;
        if (!spec.getComponentFilter().isSatisfiedBy((Object)this.componentId)) {
            return ResolvedArtifactSet.EMPTY;
        }
        if (spec.getSelectFromAllVariants() && !this.artifacts.isEmpty()) {
            return ResolvedArtifactSet.EMPTY;
        }
        try {
            variants = !spec.getSelectFromAllVariants() ? this.getOwnArtifacts() : this.getArtifactVariantsForReselection(spec.getRequestAttributes());
        }
        catch (Exception e) {
            return new BrokenResolvedArtifactSet(e);
        }
        if (variants.isEmpty() && spec.getAllowNoMatchingVariants()) {
            return ResolvedArtifactSet.EMPTY;
        }
        DefaultResolvedVariantSet variantSet = new DefaultResolvedVariantSet(this.componentId, this.producerSchema, this.overriddenAttributes, variants);
        return variantSelector.select(variantSet, spec.getRequestAttributes(), spec.getAllowNoMatchingVariants(), this::asTransformed);
    }

    private ResolvedArtifactSet asTransformed(ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolver dependenciesResolver, TransformedVariantFactory transformedVariantFactory) {
        if (this.componentId instanceof ProjectComponentIdentifier) {
            return transformedVariantFactory.transformedProjectArtifacts(this.componentId, sourceVariant, variantDefinition, dependenciesResolver);
        }
        return transformedVariantFactory.transformedExternalArtifacts(this.componentId, sourceVariant, variantDefinition, dependenciesResolver);
    }

    private ImmutableList<ResolvedVariant> getOwnArtifacts() {
        this.ownArtifacts.finalizeIfNotAlready();
        return (ImmutableList)this.ownArtifacts.get();
    }

    public ImmutableList<ResolvedVariant> calculateOwnArtifacts() {
        if (this.artifacts.isEmpty()) {
            return this.getArtifactsForGraphVariant(this.variant);
        }
        return ImmutableList.of((Object)this.variant.prepareForArtifactResolution().resolveAdhocVariant(this.variantResolver, this.artifacts));
    }

    private ImmutableList<ResolvedVariant> getArtifactVariantsForReselection(ImmutableAttributes requestAttributes) {
        VariantGraphResolveState graphVariant = this.graphVariantSelector.selectByAttributeMatchingLenient(requestAttributes, this.capabilitySelectors, this.component, this.consumerSchema, Collections.emptyList());
        if (graphVariant == null) {
            return ImmutableList.of();
        }
        return this.getArtifactsForGraphVariant(graphVariant);
    }

    private ImmutableList<ResolvedVariant> getArtifactsForGraphVariant(VariantGraphResolveState graphVariant) {
        VariantArtifactResolveState variantState = graphVariant.prepareForArtifactResolution();
        Set<? extends VariantResolveMetadata> artifactVariants = variantState.getArtifactVariants();
        ImmutableList.Builder resolved = ImmutableList.builderWithExpectedSize((int)artifactVariants.size());
        ComponentArtifactResolveMetadata componentMetadata = this.component.prepareForArtifactResolution().getArtifactMetadata();
        if (this.exclusions.mayExcludeArtifacts()) {
            for (VariantResolveMetadata variantResolveMetadata : artifactVariants) {
                resolved.add((Object)this.variantResolver.resolveVariant(componentMetadata, variantResolveMetadata, this.exclusions));
            }
        } else {
            for (VariantResolveMetadata variantResolveMetadata : artifactVariants) {
                resolved.add((Object)this.variantResolver.resolveVariant(componentMetadata, variantResolveMetadata));
            }
        }
        return resolved.build();
    }
}

