/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class ConcurrentIdentityCache<K, V> {
    private final Map<IdentityKey<K>, V> map = new ConcurrentHashMap<IdentityKey<K>, V>();

    ConcurrentIdentityCache() {
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.map.computeIfAbsent(new IdentityKey(key), k -> mappingFunction.apply((Object)((IdentityKey)k).value));
    }

    private static class IdentityKey<T> {
        private final T value;

        private IdentityKey(T value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            return ((IdentityKey)obj).value == this.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }
    }
}

