/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Named;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.ComponentWithNativeRuntime;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.toolchain.internal.MacroArgsConverter;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.SystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLibraries;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.metadata.VisualCppMetadata;
import org.gradle.util.internal.VersionNumber;

public abstract class AbstractCppBinaryVisualStudioTargetBinary
implements VisualStudioTargetBinary {
    public static final VersionNumber DEFAULT_SDK_VERSION = VersionNumber.parse((String)"8.1");
    public static final VersionNumber DEFAULT_VISUAL_STUDIO_VERSION = VersionNumber.version((int)14);
    protected final String projectName;
    private final String projectPath;
    private final CppComponent component;
    private final ProjectLayout projectLayout;

    protected AbstractCppBinaryVisualStudioTargetBinary(String projectName, String projectPath, CppComponent component, ProjectLayout projectLayout) {
        this.projectName = projectName;
        this.projectPath = projectPath;
        this.component = component;
        this.projectLayout = projectLayout;
    }

    @Override
    public VisualStudioTargetBinary.LanguageStandard getLanguageStandard() {
        return VisualStudioTargetBinary.LanguageStandard.from((List)((CppCompile)this.getBinary().getCompileTask().get()).getCompilerArgs().get());
    }

    abstract CppBinary getBinary();

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public String getComponentName() {
        return this.projectName;
    }

    @Override
    public String getVisualStudioProjectName() {
        return this.projectName + this.getProjectType().getSuffix();
    }

    @Override
    public String getVisualStudioConfigurationName() {
        String buildType = "debug";
        if (this.getBinary().isOptimized()) {
            buildType = "release";
        }
        String operatingSystemFamilySuffix = Dimensions.createDimensionSuffix((Named)this.getBinary().getTargetMachine().getOperatingSystemFamily(), (Collection)this.component.getBinaries().get().stream().map(ComponentWithNativeRuntime::getTargetMachine).map(TargetMachine::getOperatingSystemFamily).collect(Collectors.toSet()));
        String architectureSuffix = Dimensions.createDimensionSuffix((Named)this.getBinary().getTargetMachine().getArchitecture(), (Collection)this.component.getBinaries().get().stream().map(ComponentWithNativeRuntime::getTargetMachine).map(TargetMachine::getArchitecture).collect(Collectors.toSet()));
        return buildType + operatingSystemFamilySuffix + architectureSuffix;
    }

    protected String taskPath(String taskName) {
        if (":".equals(this.projectPath)) {
            return ":" + taskName;
        }
        return this.projectPath + ":" + taskName;
    }

    @Override
    public VersionNumber getVisualStudioVersion() {
        CompilerMetadata compilerMetadata;
        PlatformToolProvider provider = ((DefaultCppBinary)this.getBinary()).getPlatformToolProvider();
        if (provider.isAvailable() && (compilerMetadata = provider.getCompilerMetadata(ToolType.CPP_COMPILER)) instanceof VisualCppMetadata) {
            return ((VisualCppMetadata)compilerMetadata).getVisualStudioVersion();
        }
        return DEFAULT_VISUAL_STUDIO_VERSION;
    }

    @Override
    public VersionNumber getSdkVersion() {
        SystemLibraries systemLibraries;
        PlatformToolProvider provider = ((DefaultCppBinary)this.getBinary()).getPlatformToolProvider();
        if (provider.isAvailable() && (systemLibraries = provider.getSystemLibraries(ToolType.CPP_COMPILER)) instanceof WindowsSdkLibraries) {
            WindowsSdkLibraries sdkLibraries = (WindowsSdkLibraries)systemLibraries;
            return sdkLibraries.getSdkVersion();
        }
        return DEFAULT_SDK_VERSION;
    }

    @Override
    public List<String> getVariantDimensions() {
        return Lists.newArrayList((Object[])new String[]{this.getBinary().getName()});
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.getBinary().getCppSource();
    }

    @Override
    public FileCollection getResourceFiles() {
        return this.projectLayout.files(new Object[0]);
    }

    @Override
    public FileCollection getHeaderFiles() {
        return this.component.getHeaderFiles();
    }

    @Override
    public String getCleanTaskPath() {
        return this.taskPath("clean");
    }

    @Override
    public boolean isDebuggable() {
        return this.getBinary().isDebuggable();
    }

    @Override
    public List<String> getCompilerDefines() {
        return new MacroArgsConverter().transform(((CppCompile)this.getBinary().getCompileTask().get()).getMacros());
    }

    @Override
    public Set<File> getIncludePaths() {
        return this.getBinary().getCompileIncludePath().getFiles();
    }
}

