/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ivyservice.TypedResolveException;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.DisplayName;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;

public class ResolveExceptionMapper {
    private final DomainObjectContext domainObjectContext;
    private final DocumentationRegistry documentationRegistry;

    public ResolveExceptionMapper(DomainObjectContext domainObjectContext, DocumentationRegistry documentationRegistry) {
        this.domainObjectContext = domainObjectContext;
        this.documentationRegistry = documentationRegistry;
    }

    @Nullable
    public TypedResolveException mapFailures(Collection<Throwable> failures, String type, DisplayName contextDisplayName) {
        if (failures.isEmpty()) {
            return null;
        }
        String displayName = contextDisplayName.getDisplayName();
        if (failures.size() > 1) {
            return new TypedResolveException(type, displayName, (Iterable)failures.stream().map(failure -> this.mapRepositoryOverrideFailure(displayName, (Throwable)failure)).collect(ImmutableList.toImmutableList()));
        }
        Throwable failure2 = failures.iterator().next();
        return this.mapFailure(failure2, type, displayName);
    }

    public TypedResolveException mapFailure(Throwable failure, String type, String contextDisplayName) {
        if (!(failure instanceof TypedResolveException)) {
            return new TypedResolveException(type, contextDisplayName, (Iterable<? extends Throwable>)ImmutableList.of((Object)this.mapRepositoryOverrideFailure(contextDisplayName, failure)));
        }
        TypedResolveException resolveException = (TypedResolveException)((Object)failure);
        List mappedCauses = (List)resolveException.getCauses().stream().map(cause -> this.mapRepositoryOverrideFailure(contextDisplayName, (Throwable)cause)).collect(ImmutableList.toImmutableList());
        if (mappedCauses.equals(resolveException.getCauses())) {
            return resolveException;
        }
        return new TypedResolveException(resolveException.getType(), contextDisplayName, mappedCauses, resolveException.getResolutions());
    }

    public Throwable mapRepositoryOverrideFailure(String contextDisplayName, Throwable failure) {
        if (!(failure instanceof ModuleVersionNotFoundException) || !this.settingsRepositoriesIgnored()) {
            return failure;
        }
        ImmutableList resolutions = ImmutableList.of((Object)("The project declares repositories, effectively ignoring the repositories you have declared in the settings.\nTo determine how project repositories are declared, configure your build to fail on project repositories.\n" + this.documentationRegistry.getDocumentationRecommendationFor("information", "declaring_repositories", "sub:fail_build_on_project_repositories")));
        return new TypedResolveException("dependencies", contextDisplayName, Collections.singleton(failure), (List<String>)resolutions);
    }

    private boolean settingsRepositoriesIgnored() {
        boolean hasSettingsRepos;
        if (!(this.domainObjectContext instanceof ProjectInternal)) {
            return false;
        }
        ProjectInternal project = (ProjectInternal)this.domainObjectContext;
        try {
            hasSettingsRepos = !project.getGradle().getSettings().getDependencyResolutionManagement().getRepositories().isEmpty();
        }
        catch (Throwable e) {
            return false;
        }
        boolean hasProjectRepos = !project.getRepositories().isEmpty();
        return hasProjectRepos && hasSettingsRepos;
    }
}

