/*
 * Copyright 2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.tasks.testing.failure;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestMultipleFailuresErrorMapper;
import org.gradle.api.tasks.testing.TestFailure;

/**
 * Interface implemented by root-level classes which transform between {@link Throwable} and {@link TestFailure}.
 * <p>
 * As sometimes failure processing needs to be recursive (e.g. {@link OpenTestMultipleFailuresErrorMapper}),
 * they receive an instance implementing this interface to transform inner failures.
 *
 * @see org.gradle.api.internal.tasks.testing.junit.JUnitTestEventAdapter
 * @see org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestExecutionListener
 */
@NonNullApi
public interface RootAssertionToFailureMapper {

    TestFailure createFailure(Throwable throwable);

}
