/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.transformers;

import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemTransformer;
import org.gradle.api.problems.locations.FileLocation;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;

public class StackLocationTransformer
implements ProblemTransformer {
    private final ProblemStream problemStream;

    public StackLocationTransformer(ProblemStream problemStream) {
        this.problemStream = problemStream;
    }

    public Problem transform(Problem problem) {
        if (problem.getException() == null) {
            return problem;
        }
        ProblemDiagnostics problemDiagnostics = this.problemStream.forCurrentCaller(problem.getException());
        Location loc = problemDiagnostics.getLocation();
        if (loc != null) {
            problem.getLocations().add(new FileLocation(loc.getSourceLongDisplayName().getDisplayName(), Integer.valueOf(loc.getLineNumber()), null, null));
        }
        return problem;
    }
}

