/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.io.File;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.cache.DefaultDecompressionCacheFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.DefaultArchiveOperations;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.DefaultFilePropertyFactory;
import org.gradle.api.internal.file.DefaultFileSystemOperations;
import org.gradle.api.internal.file.DefaultProjectLayout;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.model.DefaultObjectFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.provider.DefaultPropertyFactory;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.DecompressionCacheFactory;
import org.gradle.cache.internal.scopes.DefaultProjectScopedCacheBuilderFactory;
import org.gradle.cache.scopes.ProjectScopedCacheBuilderFactory;
import org.gradle.cache.scopes.ScopedCacheBuilderFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecOperations;
import org.gradle.process.internal.DefaultExecOperations;
import org.gradle.process.internal.ExecFactory;

public class WorkerSharedProjectScopeServices {
    private final File projectDir;

    public WorkerSharedProjectScopeServices(File projectDir) {
        this.projectDir = projectDir;
    }

    void configure(ServiceRegistration registration) {
        registration.add(DefaultPropertyFactory.class);
        registration.add(DefaultFilePropertyFactory.class);
    }

    protected FileCollectionFactory createFileCollectionFactory(FileCollectionFactory parent, PathToFileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost) {
        return parent.forChildScope(fileResolver, taskDependencyFactory, propertyHost);
    }

    protected FileResolver createFileResolver(FileLookup lookup) {
        return lookup.getFileResolver(this.projectDir);
    }

    protected DefaultFileOperations createFileOperations(FileResolver fileResolver, Instantiator instantiator, DirectoryFileTreeFactory directoryFileTreeFactory, FileHasher fileHasher, DefaultResourceHandler.Factory resourceHandlerFactory, FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, FileSystem fileSystem, Factory<PatternSet> patternSetFactory, Deleter deleter, DocumentationRegistry documentationRegistry, ProviderFactory providers, TaskDependencyFactory taskDependencyFactory, DecompressionCacheFactory decompressionCache, ScopedCacheBuilderFactory cacheBuilderFactory) {
        return new DefaultFileOperations(fileResolver, instantiator, directoryFileTreeFactory, fileHasher, resourceHandlerFactory, fileCollectionFactory, objectFactory, fileSystem, patternSetFactory, deleter, documentationRegistry, taskDependencyFactory, providers, decompressionCache, cacheBuilderFactory);
    }

    protected FileSystemOperations createFileSystemOperations(ObjectFactory objectFactory, Instantiator instantiator, FileOperations fileOperations) {
        return (FileSystemOperations)instantiator.newInstance(DefaultFileSystemOperations.class, new Object[]{objectFactory, fileOperations});
    }

    protected ArchiveOperations createArchiveOperations(Instantiator instantiator, FileOperations fileOperations) {
        return (ArchiveOperations)instantiator.newInstance(DefaultArchiveOperations.class, new Object[]{fileOperations});
    }

    protected ExecOperations createExecOperations(Instantiator instantiator, ExecFactory execFactory) {
        return (ExecOperations)instantiator.newInstance(DefaultExecOperations.class, new Object[]{execFactory});
    }

    ObjectFactory createObjectFactory(InstantiatorFactory instantiatorFactory, ServiceRegistry services, Factory<PatternSet> patternSetFactory, DirectoryFileTreeFactory directoryFileTreeFactory, PropertyFactory propertyFactory, FilePropertyFactory filePropertyFactory, TaskDependencyFactory taskDependencyFactory, FileCollectionFactory fileCollectionFactory, DomainObjectCollectionFactory domainObjectCollectionFactory, NamedObjectInstantiator namedObjectInstantiator) {
        return new DefaultObjectFactory((Instantiator)instantiatorFactory.decorate((ServiceLookup)services), namedObjectInstantiator, directoryFileTreeFactory, patternSetFactory, propertyFactory, filePropertyFactory, taskDependencyFactory, fileCollectionFactory, domainObjectCollectionFactory);
    }

    DefaultProjectLayout createProjectLayout(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, TaskDependencyFactory taskDependencyFactory, FilePropertyFactory filePropertyFactory, Factory<PatternSet> patternSetFactory, PropertyHost propertyHost, FileFactory fileFactory) {
        return new DefaultProjectLayout(this.projectDir, fileResolver, taskDependencyFactory, patternSetFactory, propertyHost, fileCollectionFactory, filePropertyFactory, fileFactory);
    }

    protected ProjectScopedCacheBuilderFactory createProjectScopedCache(TemporaryFileProvider temporaryFileProvider, UnscopedCacheBuilderFactory unscopedCacheBuilderFactory) {
        return new DefaultProjectScopedCacheBuilderFactory(temporaryFileProvider.newTemporaryFile(new String[]{".cache"}), unscopedCacheBuilderFactory);
    }

    protected DecompressionCacheFactory createDecompressionCacheFactory(TemporaryFileProvider temporaryFileProvider, UnscopedCacheBuilderFactory unscopedCacheBuilderFactory) {
        return new DefaultDecompressionCacheFactory(() -> new DefaultProjectScopedCacheBuilderFactory(temporaryFileProvider.newTemporaryFile(new String[]{".cache"}), unscopedCacheBuilderFactory));
    }
}

