/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.List;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.configuration.BuildOperationScriptPlugin;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.ScriptSourceListener;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.scripts.ScriptingLanguages;
import org.gradle.scripts.ScriptingLanguage;

public class ScriptPluginFactorySelector
implements ScriptPluginFactory {
    private final ScriptPluginFactory defaultScriptPluginFactory;
    private final ProviderInstantiator providerInstantiator;
    private final BuildOperationRunner buildOperationRunner;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final ScriptSourceListener scriptSourceListener;

    public static ProviderInstantiator defaultProviderInstantiatorFor(final Instantiator instantiator) {
        return new ProviderInstantiator(){

            @Override
            public ScriptPluginFactory instantiate(String providerClassName) {
                Class<?> providerClass = this.loadProviderClass(providerClassName);
                return (ScriptPluginFactory)instantiator.newInstance(providerClass, new Object[0]);
            }

            private Class<?> loadProviderClass(String providerClassName) {
                try {
                    return this.getClass().getClassLoader().loadClass(providerClassName);
                }
                catch (ClassNotFoundException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        };
    }

    public ScriptPluginFactorySelector(ScriptPluginFactory defaultScriptPluginFactory, ProviderInstantiator providerInstantiator, BuildOperationRunner buildOperationRunner, UserCodeApplicationContext userCodeApplicationContext, ScriptSourceListener scriptSourceListener) {
        this.defaultScriptPluginFactory = defaultScriptPluginFactory;
        this.providerInstantiator = providerInstantiator;
        this.buildOperationRunner = buildOperationRunner;
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.scriptSourceListener = scriptSourceListener;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
        this.scriptSourceListener.scriptSourceObserved(scriptSource);
        ScriptPlugin scriptPlugin = this.scriptPluginFactoryFor(scriptSource.getFileName()).create(scriptSource, scriptHandler, targetScope, baseScope, topLevelScript);
        return new BuildOperationScriptPlugin(scriptPlugin, this.buildOperationRunner, this.userCodeApplicationContext);
    }

    private ScriptPluginFactory scriptPluginFactoryFor(String fileName) {
        for (ScriptingLanguage scriptingLanguage : this.scriptingLanguages()) {
            if (!fileName.endsWith(scriptingLanguage.getExtension())) continue;
            String provider = scriptingLanguage.getProvider();
            if (provider != null) {
                return this.instantiate(provider);
            }
            return this.defaultScriptPluginFactory;
        }
        return this.defaultScriptPluginFactory;
    }

    private List<ScriptingLanguage> scriptingLanguages() {
        return ScriptingLanguages.all();
    }

    private ScriptPluginFactory instantiate(String provider) {
        return this.providerInstantiator.instantiate(provider);
    }

    public static interface ProviderInstantiator {
        public ScriptPluginFactory instantiate(String var1);
    }
}

